/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.layouts;

import java.util.StringTokenizer;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.WrapperNodeFigure;
import org.eclipse.stp.bpmn.figures.WrapLabelWithToolTip;
import org.eclipse.swt.graphics.Font;

public class ActivityLayout
implements LayoutManager {
    private static final int EVENT_GATEWAYS_LABEL_MIN_WIDTH = 90;
    public static final Integer CENTER = new Integer(2);
    public static final Integer BOTTOM = new Integer(32);
    private IFigure center;
    private WrapLabel bottom;
    private int vGap = 0;
    private int hGap = 0;

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.getPreferredSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.calculatePreferredSize(container, wHint, hHint);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int prefWidth;
        Dimension prefSize = new Dimension();
        if (this.center != null && this.center.isVisible()) {
            prefSize = this.center.getPreferredSize(wHint, wHint);
        }
        if (prefSize.width < 90 && this.bottom != null && this.bottom.isVisible() && this.bottom instanceof WrapLabelWithToolTip && (prefWidth = ((WrapLabelWithToolTip)this.bottom).getTextSizeWidth(wHint, hHint)) > 90) {
            prefSize.width = 90;
        }
        return prefSize;
    }

    public void layout(IFigure container) {
        Dimension childSize;
        Rectangle area = container.getClientArea();
        if (this.bottom.getSize().height == 0) {
            area.width = area.height = Math.min(area.height, area.width);
        }
        int squaresize = 0;
        squaresize = this.bottom.getSize().height != 0 ? area.height - this.bottom.getSize().height : area.width;
        if (this.center.getMinimumSize().width > squaresize) {
            squaresize = this.center.getMinimumSize().width;
        }
        Rectangle rect = new Rectangle();
        if (this.center != null && this.center.isVisible()) {
            if (area.width < 0) {
                area.width = 0;
            }
            if (area.height < 0) {
                area.height = 0;
            }
            childSize = new Dimension(squaresize, squaresize);
            rect.setLocation(area.x, area.y);
            rect.setSize(childSize);
            this.center.setBounds(rect);
            area.height -= rect.height + this.vGap;
            area.y += rect.height + this.vGap;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            if (this.bottom instanceof WrapLabel && area.height <= 0) {
                area.height = FigureUtilities.getFontMetrics((Font)this.bottom.getFont()).getHeight() * 2;
            }
            childSize = this.bottom.getPreferredSize(area.width, area.height);
            Font f = this.bottom.getFont();
            String s = this.bottom.getText();
            Dimension d = FigureUtilities.getTextExtents((String)s, (Font)f);
            IMapMode mapMode = MapModeUtil.getMapMode((IFigure)this.bottom);
            int fontHeight = mapMode.DPtoLP(FigureUtilities.getFontMetrics((Font)f).getHeight());
            d.width = mapMode.DPtoLP(d.width);
            childSize.height = childSize.width != 0 ? fontHeight * (d.width / childSize.width) : 0;
            childSize.height += fontHeight * new StringTokenizer(s, "\n").countTokens();
            childSize.height += mapMode.DPtoLP(5);
            rect.setSize(childSize);
            rect.setLocation(area.x, area.y);
            this.bottom.setBounds(rect);
            area.height -= rect.height + this.vGap;
        }
        if (this.bottom.getSize().height != 0) {
            int x = (this.bottom.getSize().width - squaresize) / 2;
            if (x < 0) {
                this.bottom.setLocation(this.bottom.getBounds().getLocation().translate(-x, 0));
            } else {
                this.center.setLocation(this.center.getBounds().getLocation().translate(x, 0));
            }
        }
        Dimension b = new Dimension();
        b.height = this.center.getSize().height + this.bottom.getSize().height;
        b.width = Math.max(this.bottom.getSize().width, this.center.getSize().width);
        container.setSize(b.getCopy());
        if (container.getParent() instanceof WrapperNodeFigure) {
            container.getParent().setSize(b.getCopy());
        }
    }

    public void remove(IFigure child) {
        if (this.center == child) {
            this.center = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.remove(child);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 32: {
                this.bottom = (WrapLabel)child;
                break;
            }
        }
    }

    public void setHorizontalSpacing(int gap) {
        this.hGap = gap;
    }

    public void setVerticalSpacing(int gap) {
        this.vGap = gap;
    }

    public Object getConstraint(IFigure child) {
        return null;
    }

    public void invalidate() {
    }
}

