/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;

public class ActivityResizeTracker
extends DragEditPartsTracker {
    private static Field snapToHelperField;
    private static Field sourceRelativeStartPointField;
    private static Field sourceRectangleField;
    private static int FLAG_TARGET_FEEDBACK;
    private static final int FLAG_SOURCE_FEEDBACK = 16;
    protected static final int MAX_FLAG = 16;
    private int direction;
    private GraphicalEditPart owner;
    private Request sourceRequest;

    static {
        FLAG_TARGET_FEEDBACK = 32;
    }

    private static void init() {
        if (sourceRectangleField != null) {
            return;
        }
        try {
            sourceRectangleField = DragEditPartsTracker.class.getDeclaredField("sourceRectangle");
            sourceRectangleField.setAccessible(true);
            snapToHelperField = DragEditPartsTracker.class.getDeclaredField("snapToHelper");
            snapToHelperField.setAccessible(true);
            sourceRelativeStartPointField = DragEditPartsTracker.class.getDeclaredField("sourceRelativeStartPoint");
            sourceRelativeStartPointField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public ActivityResizeTracker(GraphicalEditPart owner, int direction) {
        super((EditPart)owner);
        ActivityResizeTracker.init();
        this.owner = owner;
        this.direction = direction;
        this.setDisabledCursor(SharedCursors.NO);
    }

    protected GraphicalEditPart getOwner() {
        return this.owner;
    }

    protected SnapToHelper getSnapToHelper() {
        try {
            return (SnapToHelper)snapToHelperField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected PrecisionRectangle getSourceRectangle() {
        try {
            return (PrecisionRectangle)sourceRectangleField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setSourceRectangle(PrecisionRectangle sourceRect) {
        try {
            sourceRectangleField.set((Object)this, sourceRect);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setSnapToHelper(SnapToHelper snapToHelper) {
        try {
            snapToHelperField.set((Object)this, snapToHelper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setSourceRelativeStartPointField(PrecisionPoint sourceRelativeStartPoint) {
        try {
            sourceRelativeStartPointField.set((Object)this, sourceRelativeStartPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void activate() {
        super.activate();
        if (this.owner != null) {
            IFigure figure;
            if (this.getTargetEditPart() != null) {
                this.setSnapToHelper((SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class));
            }
            if ((figure = this.owner.getFigure()) instanceof HandleBounds) {
                this.setSourceRectangle(new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()));
            } else {
                this.setSourceRectangle(new PrecisionRectangle(figure.getBounds()));
            }
            figure.translateToAbsolute((Translatable)this.getSourceRectangle());
        }
    }

    public void commitDrag() {
        this.eraseTargetFeedback();
        super.commitDrag();
    }

    protected List createOperationSet() {
        List list = super.createOperationSet();
        ToolUtilities.filterEditPartsUnderstanding((List)list, (Request)this.getSourceRequest());
        return list;
    }

    protected Request createSourceRequest() {
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize");
        request.setResizeDirection(this.getResizeDirection());
        return request;
    }

    public void deactivate() {
        this.eraseTargetFeedback();
        super.deactivate();
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        this.setFlag(16, false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.eraseSourceFeedback(this.getSourceRequest());
            ++i;
        }
    }

    protected boolean isShowingFeedback() {
        return this.getFlag(16);
    }

    protected void eraseTargetFeedback() {
        if (!this.getFlag(FLAG_TARGET_FEEDBACK)) {
            return;
        }
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().eraseTargetFeedback(this.getSourceRequest());
        }
        this.setFlag(FLAG_TARGET_FEEDBACK, false);
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Resize Handle Tracker");
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            command.add(part.getCommand(this.getSourceRequest()));
            ++i;
        }
        return command.unwrap();
    }

    protected String getCommandName() {
        return "resize";
    }

    protected Cursor getDefaultCursor() {
        return SharedCursors.getDirectionalCursor((int)this.direction, (boolean)this.getTargetEditPart().getFigure().isMirrored());
    }

    protected String getDebugName() {
        return "Resize Handle Tracker";
    }

    protected int getResizeDirection() {
        return this.direction;
    }

    protected GraphicalEditPart getTargetEditPart() {
        if (this.owner != null) {
            return (GraphicalEditPart)this.owner.getParent();
        }
        return null;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.performDrag();
        }
        return true;
    }

    protected boolean _isInDragInProgress() {
        return this.isInState(36);
    }

    protected boolean handleDragInProgress() {
        if (this._isInDragInProgress()) {
            this.updateSourceRequest();
            this.updateTargetRequest();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected void showTargetFeedback() {
        this.setFlag(FLAG_TARGET_FEEDBACK, true);
        if (this.getTargetEditPart() != null) {
            this.getTargetEditPart().showTargetFeedback(this.getSourceRequest());
        }
    }

    protected void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getSourceRequest());
            ++i;
        }
        this.setFlag(16, true);
    }

    protected void updateSourceRequest() {
        EObject semanticElement;
        GraphicalEditPart owner = this.getOwner();
        if (owner != null && owner.getModel() instanceof View && (!((semanticElement = ((View)owner.getModel()).getElement()) instanceof Activity) || ((Activity)semanticElement).getActivityType().getValue() == 0)) {
            this.superUpdateSourceRequest();
            return;
        }
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        int direction = this.getResizeDirection();
        PrecisionRectangle sourceRect = this.getSourceRectangle();
        SnapToHelper snapToHelper = this.getSnapToHelper();
        if (owner != null) {
            request.setConstrainedResize(true);
            if (direction == 20) {
                if ((float)d.height > (float)d.width * 1.0f) {
                    d.width = (int)((float)d.height / 1.0f);
                } else {
                    d.height = (int)((float)d.width * 1.0f);
                }
            } else if (direction == 9) {
                if ((float)d.height < (float)d.width * 1.0f) {
                    d.width = (int)((float)d.height / 1.0f);
                } else {
                    d.height = (int)((float)d.width * 1.0f);
                }
            } else if (direction == 17) {
                if ((float)(-d.height) > (float)d.width * 1.0f) {
                    d.width = -((int)((float)d.height / 1.0f));
                } else {
                    d.height = -((int)((float)d.width * 1.0f));
                }
            } else if (direction == 12) {
                if ((float)(-d.height) < (float)d.width * 1.0f) {
                    d.width = -((int)((float)d.height / 1.0f));
                } else {
                    d.height = -((int)((float)d.width * 1.0f));
                }
            } else if (direction == 1) {
                direction |= 0x10;
                d.width = -((int)((float)d.height / 1.0f));
            } else if (direction == 4) {
                direction |= 0x10;
                d.width = (int)((float)d.height / 1.0f);
            } else if (direction == 16) {
                direction |= 4;
                d.height = (int)((float)d.width * 1.0f);
            } else if (direction == 8) {
                direction |= 4;
                d.height = -((int)((float)d.width * 1.0f));
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        if ((direction & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((direction & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((direction & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((direction & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && snapToHelper != null) {
            PrecisionRectangle rect = sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            if (preciseResize.width != preciseResize.height) {
                preciseResize.preciseHeight = preciseResize.preciseWidth;
                preciseResize.updateInts();
            }
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }

    protected void superUpdateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        if (this.getCurrentInput().isShiftKeyDown() && this.getOwner() != null) {
            request.setConstrainedResize(true);
            int origHeight = this.getOwner().getFigure().getBounds().height;
            int origWidth = this.getOwner().getFigure().getBounds().width;
            float ratio = 1.0f;
            if (origWidth != 0 && origHeight != 0) {
                ratio = (float)origHeight / (float)origWidth;
            }
            if (this.getResizeDirection() == 20) {
                if ((float)d.height > (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 9) {
                if ((float)d.height < (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 17) {
                if ((float)(-d.height) > (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (this.getResizeDirection() == 12) {
                if ((float)(-d.height) < (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        if ((this.getResizeDirection() & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((this.getResizeDirection() & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((this.getResizeDirection() & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((this.getResizeDirection() & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && this.getSnapToHelper() != null) {
            PrecisionRectangle rect = this.getSourceRectangle().getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            this.getSnapToHelper().snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }

    protected Request getSourceRequest() {
        if (this.sourceRequest == null) {
            this.sourceRequest = this.createSourceRequest();
        }
        return this.sourceRequest;
    }

    protected boolean handleHover() {
        if (this._isInDragInProgress()) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected void handleAutoexpose() {
        this.handleDragInProgress();
    }
}

