/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.handles.ConnectionHandleForAssociation;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandleToolEx
extends ConnectionHandleTool {
    public ConnectionHandleToolEx(ConnectionHandle connectionHandle) {
        super(connectionHandle);
    }

    protected Request createTargetRequest() {
        List relTypes = null;
        ConnectionHandle connHandle = this.getConnectionHandle();
        relTypes = connHandle.isIncoming() ? ModelingAssistantService.getInstance().getRelTypesOnTarget((IAdaptable)connHandle.getOwner()) : ModelingAssistantService.getInstance().getRelTypesOnSource((IAdaptable)connHandle.getOwner());
        int borderSide = ((ConnectionHandleLocator)connHandle.getLocator()).getBorderSide();
        if (connHandle instanceof ConnectionHandleForAssociation) {
            this.setRelationTypesForAssociation((ConnectionHandleForAssociation)connHandle, relTypes, borderSide);
        } else {
            relTypes.remove(BpmnElementTypes.Association_3003);
            ArrayList<IElementType> toRemove = new ArrayList<IElementType>();
            for (IElementType eltType : relTypes) {
                if (!BpmnElementTypes.Association_3003.getId().equals(eltType.getId())) continue;
                toRemove.add(eltType);
            }
            relTypes.removeAll(toRemove);
            switch (borderSide) {
                case 1: 
                case 4: {
                    relTypes.remove(BpmnElementTypes.SequenceEdge_3001);
                    break;
                }
                case 8: 
                case 16: {
                    relTypes.remove(BpmnElementTypes.MessagingEdge_3002);
                }
            }
        }
        ListIterator it = relTypes.listIterator();
        while (it.hasNext()) {
            IElementType elem = (IElementType)it.next();
            if (!(elem instanceof INotationType)) continue;
            it.remove();
        }
        CreateUnspecifiedTypeConnectionRequest request = new CreateUnspecifiedTypeConnectionRequest(relTypes, this.useModelingAssistantService(), this.getPreferencesHint()){

            public void setTargetEditPart(EditPart part) {
                if (part instanceof SubProcessEditPart && this.getSourceEditPart() != null && ((IGraphicalEditPart)part).resolveSemanticElement().equals(((IGraphicalEditPart)this.getSourceEditPart().getParent()).resolveSemanticElement())) {
                    SubProcessEditPart subPro = (SubProcessEditPart)part;
                    IGraphicalEditPart bodyCompartmentEditPart = subPro.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
                    super.setTargetEditPart((EditPart)bodyCompartmentEditPart);
                    return;
                }
                super.setTargetEditPart(part);
            }
        };
        if (connHandle.isIncoming()) {
            request.setDirectionReversed(true);
        }
        return request;
    }

    protected boolean useModelingAssistantService() {
        return false;
    }

    protected void setRelationTypesForAssociation(ConnectionHandleForAssociation connHandle, List<IElementType> relationTypesCollector, int borderSide) {
        relationTypesCollector.remove(BpmnElementTypes.MessagingEdge_3002);
        relationTypesCollector.remove(BpmnElementTypes.SequenceEdge_3001);
    }

    protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
        final EditPart[] primaryEP = new EditPart[1];
        ArrayList editparts = new ArrayList();
        for (Object object : objects) {
            if (!(object instanceof IAdaptable)) continue;
            Object editPart = viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class));
            if (editPart instanceof IPrimaryEditPart) {
                editparts.add(editPart);
            }
            if (!(editPart instanceof ShapeEditPart)) continue;
            primaryEP[0] = (ShapeEditPart)editPart;
        }
        if (primaryEP[0] != null) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (primaryEP[0].isActive()) {
                        primaryEP[0].performRequest(new Request((Object)"direct edit"));
                    }
                }
            });
        }
    }
}

