/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.lang.reflect.Field;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.policies.PopupBarEditPolicyEx;
import org.eclipse.stp.bpmn.tools.MultipleShapesMoveTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class SelectionToolEx
extends SelectionTool {
    private static Field toolClassField;

    private static void init() {
        if (toolClassField != null) {
            return;
        }
        try {
            toolClassField = ToolEntry.class.getDeclaredField("toolClass");
            toolClassField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void setToolClass(ToolEntry toolEntry, Class toolClass) {
        SelectionToolEx.init();
        try {
            toolClassField.set(toolEntry, toolClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean handleDoubleClick(int button) {
        EditPartViewer viewer;
        if (this.isHoverActive()) {
            this.handleHoverStop();
            this.setHoverActive(false);
        }
        if ((viewer = this.getCurrentViewer()) instanceof GraphicalViewer && (this.isInState(2) || this.isInState(1))) {
            EditPart selectedEditPart = ((GraphicalViewer)viewer).getFocusEditPart();
            if (this.getCurrentInput().isShiftKeyDown()) {
                EAnnotation src;
                EObject object;
                if (selectedEditPart instanceof IGraphicalEditPart && (object = ((IGraphicalEditPart)selectedEditPart).getNotationView().getElement()) instanceof EModelElement && (src = ((EModelElement)object).getEAnnotation("genericFile")) != null) {
                    Request request = new Request((Object)"open");
                    selectedEditPart.performRequest(request);
                    return true;
                }
            } else {
                IGraphicalEditPart nodePart;
                EditPart primEditPart;
                if (!(selectedEditPart instanceof ITextAwareEditPart) && selectedEditPart instanceof IGraphicalEditPart && (primEditPart = (nodePart = (IGraphicalEditPart)selectedEditPart).getPrimaryChildEditPart()) != null && primEditPart instanceof ITextAwareEditPart) {
                    ITextAwareEditPart textPart = (ITextAwareEditPart)primEditPart;
                    selectedEditPart = textPart;
                }
                if (selectedEditPart instanceof ITextAwareEditPart) {
                    Request request = new Request((Object)"direct edit");
                    selectedEditPart.performRequest(request);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (e.stateMask == 262144 && e.keyCode == 32) {
            EditPartViewer viewer = this.getCurrentViewer();
            EditPart part = viewer.findObjectAt(this.getLocation());
            if (!(part instanceof IGraphicalEditPart)) {
                return super.handleKeyDown(e);
            }
            IGraphicalEditPart selectedEditPart = (IGraphicalEditPart)part;
            EditPolicy ep = selectedEditPart.getEditPolicy((Object)"PopupBarEditPolicy");
            PopupBarEditPolicyEx editPolicy = (PopupBarEditPolicyEx)((Object)(ep instanceof PopupBarEditPolicyEx ? ep : null));
            if (editPolicy == null) {
                IGraphicalEditPart child = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002));
                if (child == null && (child = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5003))) == null) {
                    child = selectedEditPart.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001));
                }
                if (child != null) {
                    ep = child.getEditPolicy((Object)"PopupBarEditPolicy");
                    editPolicy = (PopupBarEditPolicyEx)((Object)(ep instanceof PopupBarEditPolicyEx ? ep : null));
                }
            }
            if (editPolicy != null) {
                editPolicy.showDiagramAssistant();
                return false;
            }
        } else if (e.keyCode == 32) {
            MultipleShapesMoveTool t = new MultipleShapesMoveTool(){

                protected boolean handleKeyUp(KeyEvent e) {
                    if (e.keyCode == 32) {
                        this.getDomain().setActiveTool((Tool)SelectionToolEx.this);
                    }
                    return super.handleKeyUp(e);
                }
            };
            t.setViewer(this.getCurrentViewer());
            if (this.getCurrentInput().isMouseButtonDown(1)) {
                t.handleButtonDown(1);
            }
            this.getDomain().setActiveTool((Tool)t);
        }
        return super.handleKeyDown(e);
    }

    public void mouseDrag(MouseEvent e, EditPartViewer viewer) {
        super.mouseDrag(e, viewer);
    }
}

