/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerOperation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.stp.core.sca.WSDLPortType;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ServiceCreationOperation
extends AbstractScribblerOperation {
    public ServiceCreationOperation(IDataModel model) {
        super(model);
    }

    protected IStatus doExecute(IProgressMonitor monitor) throws ExecutionException {
        ComponentType componentType = (ComponentType)this.model.getProperty("IServiceCreationDataModelProperties.COMPONENT_TYPE");
        Service service = SCAFactory.eINSTANCE.createService();
        service.setName(this.model.getStringProperty("IServiceCreationDataModelProperties.NAME"));
        Interface interface_ = null;
        String interfaceType = this.model.getStringProperty("IServiceCreationDataModelProperties.INTERFACE_TYPE");
        if (interfaceType.equals("JAVA_INTERFACE")) {
            interface_ = SCAFactory.eINSTANCE.createJavaInterface();
            interface_.setInterface(this.model.getStringProperty("IServiceCreationDataModelProperties.INTERFACE"));
        } else if (interfaceType.equals("WSDL_PORTTYPE")) {
            interface_ = SCAFactory.eINSTANCE.createWSDLPortType();
            ((WSDLPortType)interface_).setInterface(this.model.getStringProperty("IServiceCreationDataModelProperties.INTERFACE"));
        }
        service.setInterface(interface_);
        componentType.getServices().add(service);
        this.model.setProperty("IAbstractScribblerDataModelProperties.RESULT", (Object)service);
        return OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }

    protected IStatus doUndo(IProgressMonitor monitor) throws ExecutionException {
        return null;
    }
}

