/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import java.util.Set;
import javax.wsdl.Import;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.delete.operations.DeletePropertyOperation;
import org.eclipse.stp.core.delete.operations.IDeletePropertyDataModelProperties;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeletePropertyDataModelProvider
extends AbstractScribblerDataModelProvider
implements IDeletePropertyDataModelProperties {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IDeletePropertyDataModelProperties.COMPONENT_TYPE");
        propertyNames.add("IDeletePropertyDataModelProperties.PROPERTY_NAMES");
        return propertyNames;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IDeletePropertyDataModelProperties.PROPERTY_NAMES")) {
            return this.validatePropertyNames();
        }
        if (propertyName.equals("IDeletePropertyDataModelProperties.COMPONENT_TYPE")) {
            return this.validatePart();
        }
        return super.validate(propertyName);
    }

    private IStatus validatePart() {
        Object object = this.getProperty("IDeletePropertyDataModelProperties.COMPONENT_TYPE");
        if (!(object instanceof ComponentType || object instanceof Import || object instanceof EntryPoint)) {
            return STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        return OK_STATUS;
    }

    public IDataModelOperation getDefaultOperation() {
        return new DeletePropertyOperation(this.model);
    }

    private IStatus validatePropertyNames() {
        ComponentType componentType = (ComponentType)this.model.getProperty("IDeletePropertyDataModelProperties.COMPONENT_TYPE");
        List properties = componentType.getProperties();
        String[] propertyNames = (String[])this.model.getProperty("IDeletePropertyDataModelProperties.PROPERTY_NAMES");
        Assert.isTrue((properties.size() >= propertyNames.length ? 1 : 0) != 0);
        int i = 0;
        while (i < propertyNames.length) {
            Property property = null;
            int propertyIndex = 0;
            while (propertyIndex < properties.size()) {
                property = (Property)properties.get(propertyIndex);
                if (property.getName().equals(propertyNames[i])) break;
                property = null;
                ++propertyIndex;
            }
            if (property == null) {
                return STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.propertyName_not_inComponentType, (Object)propertyNames[i]), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

