/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

/**
 * Provides a callback interface to respond to error conditions that occur
 * during the operation of an IEditModel.
 */
public interface IEditModelErrorHandler {

   void handleLoadFailed(URI anAttemptedURI, Exception e);

   void handleLoadFailed(Resource resource, Exception e);

   void handleSaveFailed(Resource resource, Exception e);

   void handleRevertFailed(Resource resource, Exception e);

   void handleGeneralFailure(Object o, Exception e);
}
