/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.runtime.IStatus;

/**
 * This interface provides callbacks to be handled by the clients of the
 * IEditModel framework to prompt the user when necessary or to enforce a
 * default policy that does not require a formal user prompt (e.g. "Save
 * Always").
 */
public interface IHumanInteractionController {

   interface Response {
      /**
       * Indicates the response from the user or from the automatic policy. A
       * <b>null </b> value indicates "Cancel", a non- <b>null </b> value of
       * <b>true </b> indicates "Yes", and a non- <b>null </b> value of <b>false
       * </b> indicates "No".
       * 
       * @return <b>null </b> for "Cancel", <b>true </b> for "Yes", and <b>false
       *         </b> for "No"
       * @see Boolean#TRUE
       * @see Boolean#FALSE
       */
      Boolean shouldProceed();
   }

   IHumanInteractionController.Response requestDirection(IStatus status);

   IHumanInteractionController.Response declareInformation(IStatus status);

   IHumanInteractionController.Response declareWarning(IStatus status);

   IHumanInteractionController.Response declareError(IStatus status);

}
