/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;

public class ScribblerEMFCommandStack implements CommandStack {

   private IEditModelScribbler scribbler;

   public ScribblerEMFCommandStack(IEditModelScribbler aScribbler) {
      scribbler = aScribbler;
   }

   public void execute(Command command) {
      scribbler.execute(new EMFUndoableOperation(command), null, null);
   }

   public boolean canUndo() {
      return true;
   }

   public void undo() {
      scribbler.undoLast(null, null);
   }

   public boolean canRedo() {
      // TODO Auto-generated method stub
      return false;
   }

   public Command getUndoCommand() {
      throw new UnsupportedOperationException(
            "ScribblerEMFCommandStack.getUndoCommand is unsupported"); //$NON-NLS-1$
   }

   public Command getRedoCommand() {
      throw new UnsupportedOperationException(
            "ScribblerEMFCommandStack.getRedoCommand is unsupported"); //$NON-NLS-1$
   }

   public Command getMostRecentCommand() {
      throw new UnsupportedOperationException(
            "ScribblerEMFCommandStack.getMostRecentCommand is unsupported"); //$NON-NLS-1$
   }

   public void redo() {
      scribbler.redoLast(null, null);

   }

   public void flush() {
      scribbler.flushOperationHistory(null);
   }

   public void addCommandStackListener(CommandStackListener listener) {
      // TODO Auto-generated method stub

   }

   public void removeCommandStackListener(CommandStackListener listener) {
      // TODO Auto-generated method stub

   }

}
