/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.delete.operations.DeleteReferenceOperation;
import org.eclipse.stp.core.delete.operations.IDeleteReferenceDataModelProperties;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeleteReferenceDataModelProvider
extends AbstractScribblerDataModelProvider
implements IDeleteReferenceDataModelProperties {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IDeleteReferenceDataModelProperties.COMPONENT_TYPE");
        propertyNames.add("IDeleteReferenceDataModelProperties.REFERENCE_NAMES");
        return propertyNames;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IDeleteReferenceDataModelProperties.REFERENCE_NAMES")) {
            return this.validateReferenceNames();
        }
        if (propertyName.equals("IDeleteReferenceDataModelProperties.COMPONENT_TYPE")) {
            return this.validateComponent();
        }
        return super.validate(propertyName);
    }

    private IStatus validateComponent() {
        Object object = this.model.getProperty("IDeleteReferenceDataModelProperties.COMPONENT_TYPE");
        if (object == null || !(object instanceof ComponentType)) {
            return STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        return OK_STATUS;
    }

    public IDataModelOperation getDefaultOperation() {
        return new DeleteReferenceOperation(this.model);
    }

    private IStatus validateReferenceNames() {
        ComponentType componentType = (ComponentType)this.model.getProperty("IDeleteReferenceDataModelProperties.COMPONENT_TYPE");
        List references = componentType.getReferences();
        String[] referenceNames = (String[])this.model.getProperty("IDeleteReferenceDataModelProperties.REFERENCE_NAMES");
        Assert.isTrue((references.size() >= referenceNames.length ? 1 : 0) != 0);
        int i = 0;
        while (i < referenceNames.length) {
            Reference reference = null;
            int referenceIndex = 0;
            while (referenceIndex < references.size()) {
                reference = (Reference)references.get(referenceIndex);
                if (reference.getName().equals(referenceNames[i])) break;
                reference = null;
                ++referenceIndex;
            }
            if (reference == null) {
                return STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.referenceName_not_inComponentType, (Object)referenceNames[i]), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

