/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.internal.introspection.SafeIntrospector;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.Property;
import org.eclipse.stp.core.sca.Reference;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.Service;

public class ComponentTypeImpl
extends SCAInternalObjectImpl
implements ComponentType {
    public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved.";
    protected EList services = null;
    protected EList references = null;
    protected EList properties = null;
    protected FeatureMap any = null;
    protected FeatureMap anyAttribute = null;
    private boolean hasIntrospectedServices = false;
    private boolean hasIntrospectedReferences = false;
    private boolean hasIntrospectedProperties = false;

    protected ComponentTypeImpl() {
    }

    protected EClass eStaticClass() {
        return SCAPackage.eINSTANCE.getComponentType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServices() {
        if (!this.hasIntrospectedServices) {
            ComponentTypeImpl componentTypeImpl = this;
            synchronized (componentTypeImpl) {
                if (!this.hasIntrospectedServices) {
                    SafeIntrospector safeIntrospector = new SafeIntrospector(){

                        public void run() throws Exception {
                            IComponentTypeIntrospector introspector = ComponentTypeImpl.this.findIntrospector();
                            if (introspector != null) {
                                introspector.introspect(0, ComponentTypeImpl.this.getServicesGen());
                            }
                        }
                    };
                    this.eSetDeliver(false);
                    Platform.run((ISafeRunnable)safeIntrospector);
                    this.eSetDeliver(true);
                    this.hasIntrospectedServices = true;
                }
            }
        }
        return this.getServicesGen();
    }

    public List getServicesGen() {
        if (this.services == null) {
            this.services = new EObjectContainmentEList(Service.class, (InternalEObject)this, 0);
        }
        return this.services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getReferences() {
        if (!this.hasIntrospectedReferences) {
            ComponentTypeImpl componentTypeImpl = this;
            synchronized (componentTypeImpl) {
                if (!this.hasIntrospectedReferences) {
                    SafeIntrospector safeIntrospector = new SafeIntrospector(){

                        public void run() throws Exception {
                            IComponentTypeIntrospector introspector = ComponentTypeImpl.this.findIntrospector();
                            if (introspector != null) {
                                introspector.introspect(1, ComponentTypeImpl.this.getReferencesGen());
                            }
                        }
                    };
                    this.eSetDeliver(false);
                    Platform.run((ISafeRunnable)safeIntrospector);
                    this.eSetDeliver(true);
                    this.hasIntrospectedReferences = true;
                }
            }
        }
        return this.getReferencesGen();
    }

    public List getReferencesGen() {
        if (this.references == null) {
            this.references = new EObjectContainmentEList(Reference.class, (InternalEObject)this, 1);
        }
        return this.references;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getProperties() {
        if (!this.hasIntrospectedProperties) {
            ComponentTypeImpl componentTypeImpl = this;
            synchronized (componentTypeImpl) {
                if (!this.hasIntrospectedProperties) {
                    SafeIntrospector safeIntrospector = new SafeIntrospector(){

                        public void run() throws Exception {
                            IComponentTypeIntrospector introspector = ComponentTypeImpl.this.findIntrospector();
                            if (introspector != null) {
                                introspector.introspect(2, ComponentTypeImpl.this.getPropertiesGen());
                            }
                        }
                    };
                    this.eSetDeliver(false);
                    Platform.run((ISafeRunnable)safeIntrospector);
                    this.eSetDeliver(true);
                    this.hasIntrospectedProperties = true;
                }
            }
        }
        return this.getPropertiesGen();
    }

    public List getPropertiesGen() {
        if (this.properties == null) {
            this.properties = new EObjectContainmentEList(Property.class, (InternalEObject)this, 2);
        }
        return this.properties;
    }

    public FeatureMap getAny() {
        if (this.any == null) {
            this.any = new BasicFeatureMap((InternalEObject)this, 3);
        }
        return this.any;
    }

    public FeatureMap getAnyAttribute() {
        if (this.anyAttribute == null) {
            this.anyAttribute = new BasicFeatureMap((InternalEObject)this, 4);
        }
        return this.anyAttribute;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getServices()).basicRemove((Object)otherEnd, msgs);
                }
                case 1: {
                    return ((InternalEList)this.getReferences()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return ((InternalEList)this.getAny()).basicRemove((Object)otherEnd, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getAnyAttribute()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getServices();
            }
            case 1: {
                return this.getReferences();
            }
            case 2: {
                return this.getProperties();
            }
            case 3: {
                return this.getAny();
            }
            case 4: {
                return this.getAnyAttribute();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getServices().clear();
                this.getServices().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getAny().clear();
                this.getAny().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getAnyAttribute().clear();
                this.getAnyAttribute().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getServices().clear();
                return;
            }
            case 1: {
                this.getReferences().clear();
                return;
            }
            case 2: {
                this.getProperties().clear();
                return;
            }
            case 3: {
                this.getAny().clear();
                return;
            }
            case 4: {
                this.getAnyAttribute().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.services != null && !this.services.isEmpty();
            }
            case 1: {
                return this.references != null && !this.references.isEmpty();
            }
            case 2: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 3: {
                return this.any != null && !this.any.isEmpty();
            }
            case 4: {
                return this.anyAttribute != null && !this.anyAttribute.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (any: ");
        result.append(this.any);
        result.append(", anyAttribute: ");
        result.append(this.anyAttribute);
        result.append(')');
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        ComponentTypeImpl componentTypeImpl = this;
        synchronized (componentTypeImpl) {
            this.eSetDeliver(false);
            if (this.hasIntrospectedProperties) {
                this.getPropertiesGen().clear();
            }
            if (this.hasIntrospectedServices) {
                this.getServicesGen().clear();
            }
            if (this.hasIntrospectedReferences) {
                this.getReferencesGen().clear();
            }
            this.hasIntrospectedProperties = false;
            this.hasIntrospectedReferences = false;
            this.hasIntrospectedServices = false;
            this.eSetDeliver(true);
        }
    }

    public Object resolveImplementation() {
        IComponentTypeIntrospector introspector = this.findIntrospector();
        return introspector != null ? introspector.resolveImplementation() : null;
    }

    public Reference getReference(String name) {
        if (name != null) {
            List references = this.getReferences();
            int size = references.size();
            int i = 0;
            while (i < size) {
                Reference reference = (Reference)references.get(i);
                if (name.equals(reference.getName())) {
                    return reference;
                }
                ++i;
            }
        }
        return null;
    }

    public Service getService(String serviceName) {
        if (serviceName != null) {
            List services = this.getServices();
            int size = services.size();
            int i = 0;
            while (i < size) {
                Service service = (Service)services.get(i);
                if (serviceName.equals(service.getName())) {
                    return service;
                }
                ++i;
            }
        }
        return null;
    }

    public Service getService(Interface interfaze) {
        if (interfaze != null) {
            List services = this.getServices();
            int size = services.size();
            int i = 0;
            while (i < size) {
                Service service = (Service)services.get(i);
                if (interfaze.equals(service.getInterface())) {
                    return service;
                }
                ++i;
            }
        }
        return null;
    }

    public Property getProperty(String name) {
        if (name != null) {
            List properties = this.getProperties();
            int size = properties.size();
            int i = 0;
            while (i < size) {
                Property property = (Property)properties.get(i);
                if (name.equals(property.getName())) {
                    return property;
                }
                ++i;
            }
        }
        return null;
    }

    private IComponentTypeIntrospector findIntrospector() {
        IComponentTypeIntrospector introspector = (IComponentTypeIntrospector)EcoreUtil.getAdapter((List)this.eAdapters(), (Object)IComponentTypeIntrospector.ADAPTER_TYPE);
        return introspector;
    }
}

