/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.sca.SCAInternalObjectImpl;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.sca.AbstractService;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.WireTarget;
import org.eclipse.stp.core.sca.impl.FeatureAwareList;

public class EntryPointImpl
extends SCAInternalObjectImpl
implements EntryPoint {
    public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved.";
    protected FeatureMap interfaceGroup = null;
    protected FeatureMap bindingGroup = null;
    protected EList referenceTargets = null;
    protected FeatureMap any = null;
    protected static final String MULTIPLICITY_EDEFAULT = "1..1";
    protected String multiplicity = "1..1";
    protected boolean multiplicityESet = false;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected FeatureMap anyAttribute = null;
    private List wiredTargets;
    private boolean hasResolvedWiredTargets = false;
    private List bindings;

    protected EntryPointImpl() {
    }

    protected EClass eStaticClass() {
        return SCAPackage.eINSTANCE.getEntryPoint();
    }

    public FeatureMap getInterfaceGroup() {
        if (this.interfaceGroup == null) {
            this.interfaceGroup = new BasicFeatureMap((InternalEObject)this, 0);
        }
        return this.interfaceGroup;
    }

    public Interface getInterface() {
        return (Interface)this.getInterfaceGroup().get((EStructuralFeature)SCAPackage.eINSTANCE.getEntryPoint_Interface(), true);
    }

    public NotificationChain basicSetInterface(Interface newInterface, NotificationChain msgs) {
        return ((FeatureMap.Internal)this.getInterfaceGroup()).basicAdd((EStructuralFeature)SCAPackage.eINSTANCE.getEntryPoint_Interface(), (Object)newInterface, msgs);
    }

    public void setInterface(Interface newInterface) {
        if (newInterface != null) {
            EStructuralFeature feature = FeatureAdapter.getFeature(newInterface);
            Assert.isNotNull((Object)feature);
            this.getInterfaceGroup().set(feature, (Object)newInterface);
        } else {
            this.setInterfaceGen(null);
        }
    }

    public void setInterfaceGen(Interface newInterface) {
        ((FeatureMap.Internal)this.getInterfaceGroup()).set((EStructuralFeature)SCAPackage.eINSTANCE.getEntryPoint_Interface(), (Object)newInterface);
    }

    public FeatureMap getBindingGroup() {
        if (this.bindingGroup == null) {
            this.bindingGroup = new BasicFeatureMap((InternalEObject)this, 2);
        }
        return this.bindingGroup;
    }

    public List getBindings() {
        if (this.bindings == null) {
            this.bindings = new FeatureAwareList((EStructuralFeature)SCAPackage.eINSTANCE.getEntryPoint_Bindings(), (FeatureMap.Internal)this.getBindingGroup());
        }
        return this.bindings;
    }

    public List getBindingsGen() {
        return (List)this.getBindingGroup().list((EStructuralFeature)SCAPackage.eINSTANCE.getEntryPoint_Bindings());
    }

    public List getReferenceTargets() {
        if (this.hasResolvedWiredTargets) {
            return this.getReferenceTargetURIsFromWireTargets();
        }
        return this.getReferenceTargetsGen();
    }

    private List getReferenceTargetURIsFromWireTargets() {
        if (this.wiredTargets.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> uris = new ArrayList<String>(this.wiredTargets.size());
        int i = 0;
        while (i < this.wiredTargets.size()) {
            uris.add(((WireTarget)this.wiredTargets.get(i)).getName());
            ++i;
        }
        return uris;
    }

    public List getReferenceTargetsGen() {
        if (this.referenceTargets == null) {
            this.referenceTargets = new EDataTypeEList(String.class, (InternalEObject)this, 4);
        }
        return this.referenceTargets;
    }

    public FeatureMap getAny() {
        if (this.any == null) {
            this.any = new BasicFeatureMap((InternalEObject)this, 5);
        }
        return this.any;
    }

    public String getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(String newMultiplicity) {
        String oldMultiplicity = this.multiplicity;
        this.multiplicity = newMultiplicity;
        boolean oldMultiplicityESet = this.multiplicityESet;
        this.multiplicityESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldMultiplicity, (Object)this.multiplicity, !oldMultiplicityESet));
        }
    }

    public void unsetMultiplicity() {
        String oldMultiplicity = this.multiplicity;
        boolean oldMultiplicityESet = this.multiplicityESet;
        this.multiplicity = MULTIPLICITY_EDEFAULT;
        this.multiplicityESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6, (Object)oldMultiplicity, (Object)MULTIPLICITY_EDEFAULT, oldMultiplicityESet));
        }
    }

    public boolean isSetMultiplicity() {
        return this.multiplicityESet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldName, (Object)this.name));
        }
    }

    public FeatureMap getAnyAttribute() {
        if (this.anyAttribute == null) {
            this.anyAttribute = new BasicFeatureMap((InternalEObject)this, 8);
        }
        return this.anyAttribute;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getInterfaceGroup()).basicRemove((Object)otherEnd, msgs);
                }
                case 1: {
                    return this.basicSetInterface(null, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getBindingGroup()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return ((InternalEList)this.getBindings()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getAny()).basicRemove((Object)otherEnd, msgs);
                }
                case 8: {
                    return ((InternalEList)this.getAnyAttribute()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getInterfaceGroup();
            }
            case 1: {
                return this.getInterface();
            }
            case 2: {
                return this.getBindingGroup();
            }
            case 3: {
                return this.getBindings();
            }
            case 4: {
                return this.getReferenceTargets();
            }
            case 5: {
                return this.getAny();
            }
            case 6: {
                return this.getMultiplicity();
            }
            case 7: {
                return this.getName();
            }
            case 8: {
                return this.getAnyAttribute();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getInterfaceGroup().clear();
                this.getInterfaceGroup().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setInterface((Interface)newValue);
                return;
            }
            case 2: {
                this.getBindingGroup().clear();
                this.getBindingGroup().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getBindings().clear();
                this.getBindings().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getReferenceTargets().clear();
                this.getReferenceTargets().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getAny().clear();
                this.getAny().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setMultiplicity((String)newValue);
                return;
            }
            case 7: {
                this.setName((String)newValue);
                return;
            }
            case 8: {
                this.getAnyAttribute().clear();
                this.getAnyAttribute().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getInterfaceGroup().clear();
                return;
            }
            case 1: {
                this.setInterface(null);
                return;
            }
            case 2: {
                this.getBindingGroup().clear();
                return;
            }
            case 3: {
                this.getBindings().clear();
                return;
            }
            case 4: {
                this.getReferenceTargets().clear();
                return;
            }
            case 5: {
                this.getAny().clear();
                return;
            }
            case 6: {
                this.unsetMultiplicity();
                return;
            }
            case 7: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 8: {
                this.getAnyAttribute().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.interfaceGroup != null && !this.interfaceGroup.isEmpty();
            }
            case 1: {
                return this.getInterface() != null;
            }
            case 2: {
                return this.bindingGroup != null && !this.bindingGroup.isEmpty();
            }
            case 3: {
                return !this.getBindings().isEmpty();
            }
            case 4: {
                return this.referenceTargets != null && !this.referenceTargets.isEmpty();
            }
            case 5: {
                return this.any != null && !this.any.isEmpty();
            }
            case 6: {
                return this.isSetMultiplicity();
            }
            case 7: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 8: {
                return this.anyAttribute != null && !this.anyAttribute.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (interfaceGroup: ");
        result.append(this.interfaceGroup);
        result.append(", bindingGroup: ");
        result.append(this.bindingGroup);
        result.append(", referenceTargets: ");
        result.append(this.referenceTargets);
        result.append(", any: ");
        result.append(this.any);
        result.append(", multiplicity: ");
        if (this.multiplicityESet) {
            result.append(this.multiplicity);
        } else {
            result.append("<unset>");
        }
        result.append(", name: ");
        result.append(this.name);
        result.append(", anyAttribute: ");
        result.append(this.anyAttribute);
        result.append(')');
        return result.toString();
    }

    public int getFlags() {
        return 5;
    }

    public boolean matches(WireTarget wireTarget) {
        Assert.isNotNull((Object)wireTarget);
        if (this.getInterface() != null) {
            return this.getInterface().equals(wireTarget.getInterface());
        }
        return false;
    }

    public void createWireToTarget(WireTarget wireTarget) {
        this.getWiredTargetsGen().add(wireTarget);
        this.getReferenceTargetsGen().add(wireTarget.getName());
    }

    public List getWiredTargets() {
        if (!this.hasResolvedWiredTargets) {
            this.hasResolvedWiredTargets = true;
            if (this.wiredTargets == null) {
                this.wiredTargets = new ArrayList(this.getReferenceTargetsGen().size());
            }
            this.resolveWiredTargets();
        }
        return this.wiredTargets;
    }

    private List getWiredTargetsGen() {
        if (this.wiredTargets == null) {
            this.wiredTargets = new ArrayList(this.getReferenceTargetsGen().size() + 1);
        }
        return this.wiredTargets;
    }

    private Composite getComposite() {
        return (Composite)this.eContainer();
    }

    private void resolveWiredTargets() {
        Composite composite;
        if (this.referenceTargets != null && !this.referenceTargets.isEmpty() && (composite = this.getComposite()) != null) {
            int i = 0;
            while (i < this.referenceTargets.size()) {
                WireTarget target = composite.resolveWireTarget((String)this.referenceTargets.get(i));
                if (target != null && !this.wiredTargets.contains(target)) {
                    this.wiredTargets.add(target);
                }
                ++i;
            }
        }
    }

    public boolean isResolved() {
        return true;
    }

    public boolean deleteWireToTarget(WireTarget wireTarget) {
        boolean result = false;
        if (this.hasResolvedWiredTargets) {
            result = this.getWiredTargetsGen().remove(wireTarget);
        }
        result = this.getReferenceTargetsGen().remove(wireTarget.getName()) || result;
        return result;
    }

    public boolean isComponentOwned() {
        return false;
    }

    public boolean hasWireToTarget(WireTarget wireTarget) {
        block5: {
            block6: {
                if (wireTarget == null) break block5;
                if (!this.hasResolvedWiredTargets) break block6;
                if (this.wiredTargets.contains(wireTarget)) {
                    return true;
                }
                int i = 0;
                while (i < this.wiredTargets.size()) {
                    WireTarget target = (WireTarget)this.wiredTargets.get(i);
                    if (wireTarget.getName().equals(target.getName())) {
                        return true;
                    }
                    ++i;
                }
                break block5;
            }
            if (this.getReferenceTargetsGen().isEmpty()) break block5;
            List references = this.getReferenceTargetsGen();
            int i = 0;
            while (i < references.size()) {
                if (wireTarget.getName().equals(references.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean matches(AbstractService service) {
        Assert.isNotNull((Object)service);
        if (this.getInterface() != null) {
            return this.getInterface().equals(service.getInterface());
        }
        return false;
    }
}

