/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

/**
 * The ResourceDescriptor describes a specific resource or the rules for
 * locating a particular kind of Resource. The goal of this object is to reduce
 * our dependency on specific locations in a "context" (read: "project" or
 * "component").
 * <p>
 * Clients can choose how to create ResourceDescriptors, and the structure of
 * this object will evolve as new ways to identify Resources are found or
 * invented. The initially proposed approach is to specify a "standardURI"
 * (where the Resource 'should' be) and a "localPath" (where the Resource
 * actually exists. Thus, clients should first check the localPath and then fall
 * back on the standardURI. (The types of these fields might need to be
 * consolidated).
 * </p>
 * <p>
 * The ResourceDescriptor will define an algorithm for how the information
 * available in this object should be used to identify specific Resources in a
 * collection of Resources.
 * </p>
 * 
 * @see org.eclipse.stp.core.infrastructure.emf.IScribblerDomain
 */
public interface IResourceDescriptor {

   boolean isLoadAsReadOnly();

   /**
    * 
    * @return The protocol to use when requesting a resource (e.g.
    *         "platform:/resource" or "comptype:"). Do not supply a trailing
    *         slash.
    */
   String getRequestProtocol();

   /**
    * Return the workspace relative location where the resource was found.
    * 
    * @return
    */
   IPath getLocalPath();

   /**
    * Return the default relative location where this resource could be found.
    * This method may be used when creating a new resource.
    * 
    * Example: "META-INF/ejb-jar.xml"
    * 
    * @return
    */
   IPath getDefaultPath();

   /**
    * A ResourceDescriptor might be able to indicate what it matches.
    * 
    * @param file
    * @return
    */
   boolean matches(IFile file);
}
