/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.emf.IEditModelErrorHandler;

public class LoggerErrorHandler implements IEditModelErrorHandler {

   public static final LoggerErrorHandler INSTANCE    = new LoggerErrorHandler();

   private static final URI               UNKNOWN_URI = URI
                                                            .createURI("Unknown Path"); //$NON-NLS-1$

   private LoggerErrorHandler() {
   }

   public void handleLoadFailed(URI anAttemptedURI, Exception e) {
      EMFInfrastructurePlugin.log(new Status(IStatus.ERROR,
            EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind(
                  Messages.Could_not_load_resource, anAttemptedURI), e));
   }

   public void handleLoadFailed(Resource resource, Exception e) {
      URI uri = resource != null ? resource.getURI() : UNKNOWN_URI;
      EMFInfrastructurePlugin.log(new Status(IStatus.ERROR,
            EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind(
                  Messages.Could_not_load_resource, uri), e));
   }

   public void handleSaveFailed(Resource resource, Exception e) {
      URI uri = resource != null ? resource.getURI() : UNKNOWN_URI;
      EMFInfrastructurePlugin.log(new Status(IStatus.ERROR,
            EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind(
                  Messages.Could_not_save_resource, uri), e));
   }

   public void handleRevertFailed(Resource resource, Exception e) {
      URI uri = resource != null ? resource.getURI() : UNKNOWN_URI;
      EMFInfrastructurePlugin.log(new Status(IStatus.ERROR,
            EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind(
                  Messages.Could_not_revert_resource, uri), e));
   }

   public void handleGeneralFailure(Object target, Exception e) {
      EMFInfrastructurePlugin.log(new Status(IStatus.ERROR,
            EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind(
                  Messages.Problem_with_resource, target), e));

   }

}
