/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReadOnlyAdapter extends AdapterImpl {

   public ReadOnlyAdapter findAdapter(Resource aResource) {
      return (ReadOnlyAdapter) EcoreUtil.getAdapter(aResource.eAdapters(),
            ReadOnlyAdapter.this);
   }

   public boolean isAdapterForType(Object type) {
      // only return true if its this specific readOnlyAdapter
      return type == ReadOnlyAdapter.this;
   }
}
