/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.internal.infrastructure.emfworkbench;

public class ResourceHandlerPriority {

   public static final ResourceHandlerPriority LOWEST  = new ResourceHandlerPriority(
                                                             0);

   public static final ResourceHandlerPriority LOWER   = new ResourceHandlerPriority(
                                                             1);

   public static final ResourceHandlerPriority LOW     = new ResourceHandlerPriority(
                                                             2);

   public static final ResourceHandlerPriority NORMAL  = new ResourceHandlerPriority(
                                                             3);

   public static final ResourceHandlerPriority HIGH    = new ResourceHandlerPriority(
                                                             4);

   public static final ResourceHandlerPriority HIGHER  = new ResourceHandlerPriority(
                                                             5);

   public static final ResourceHandlerPriority HIGHEST = new ResourceHandlerPriority(
                                                             6);

   private final int                           priority;

   private ResourceHandlerPriority(int thePriority) {
      priority = thePriority;
   }

   public int getPriority() {
      return priority;
   }

}
