/**
 * <copyright> </copyright>
 * 
 * $Id: PropsPackage.java,v 1.1 2006-03-31 21:58:54 melder Exp $
 */
package org.eclipse.stp.core.tests.properties;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.stp.core.sca.SCAPackage;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.tests.props.PropsFactory
 * @model kind="package"
 * @generated
 */
public interface PropsPackage extends EPackage {
   /**
    * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String       eNAME                                    = "props";                                    //$NON-NLS-1$

   /**
    * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String       eNS_URI                                  = "http://www.acme.org/properties";           //$NON-NLS-1$

   /**
    * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String       eNS_PREFIX                               = "props";                                    //$NON-NLS-1$

   /**
    * The singleton instance of the package. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   PropsPackage eINSTANCE                                = org.eclipse.stp.core.tests.properties.impl.PropsPackageImpl
                                                               .init();

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.tests.props.impl.DocumentRootImpl <em>Document Root</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.tests.props.impl.DocumentRootImpl
    * @see org.eclipse.stp.core.tests.props.impl.PropsPackageImpl#getDocumentRoot()
    * @generated
    */
   int          DOCUMENT_ROOT                            = 0;

   /**
    * The feature id for the '<em><b>Mixed</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          DOCUMENT_ROOT__MIXED                     = 0;

   /**
    * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          DOCUMENT_ROOT__XMLNS_PREFIX_MAP          = 1;

   /**
    * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          DOCUMENT_ROOT__XSI_SCHEMA_LOCATION       = 2;

   /**
    * The feature id for the '<em><b>Implementation Properties</b></em>'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          DOCUMENT_ROOT__IMPLEMENTATION_PROPERTIES = 3;

   /**
    * The number of structural features of the the '<em>Document Root</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          DOCUMENT_ROOT_FEATURE_COUNT              = 4;

   /**
    * The meta object id for the '{@link org.eclipse.stp.core.tests.props.impl.PropertiesImplementationImpl <em>Properties Implementation</em>}'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @see org.eclipse.stp.core.tests.props.impl.PropertiesImplementationImpl
    * @see org.eclipse.stp.core.tests.props.impl.PropsPackageImpl#getPropertiesImplementation()
    * @generated
    */
   int          PROPERTIES_IMPLEMENTATION                = 1;

   /**
    * The feature id for the '<em><b>Any</b></em>' attribute list. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          PROPERTIES_IMPLEMENTATION__ANY           = SCAPackage.IMPLEMENTATION_FEATURE_COUNT + 0;

   /**
    * The feature id for the '<em><b>Properties</b></em>' attribute. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          PROPERTIES_IMPLEMENTATION__PROPERTIES    = SCAPackage.IMPLEMENTATION_FEATURE_COUNT + 1;

   /**
    * The feature id for the '<em><b>Any Attribute</b></em>' attribute
    * list. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          PROPERTIES_IMPLEMENTATION__ANY_ATTRIBUTE = SCAPackage.IMPLEMENTATION_FEATURE_COUNT + 2;

   /**
    * The number of structural features of the the '<em>Properties Implementation</em>'
    * class. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    * @ordered
    */
   int          PROPERTIES_IMPLEMENTATION_FEATURE_COUNT  = SCAPackage.IMPLEMENTATION_FEATURE_COUNT + 3;

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.tests.props.DocumentRoot <em>Document Root</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Document Root</em>'.
    * @see org.eclipse.stp.core.tests.props.DocumentRoot
    * @generated
    */
   EClass getDocumentRoot();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.tests.props.DocumentRoot#getMixed <em>Mixed</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Mixed</em>'.
    * @see org.eclipse.stp.core.tests.props.DocumentRoot#getMixed()
    * @see #getDocumentRoot()
    * @generated
    */
   EAttribute getDocumentRoot_Mixed();

   /**
    * Returns the meta object for the map '{@link org.eclipse.stp.core.tests.props.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the map '<em>XMLNS Prefix Map</em>'.
    * @see org.eclipse.stp.core.tests.props.DocumentRoot#getXMLNSPrefixMap()
    * @see #getDocumentRoot()
    * @generated
    */
   EReference getDocumentRoot_XMLNSPrefixMap();

   /**
    * Returns the meta object for the map '{@link org.eclipse.stp.core.tests.props.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the map '<em>XSI Schema Location</em>'.
    * @see org.eclipse.stp.core.tests.props.DocumentRoot#getXSISchemaLocation()
    * @see #getDocumentRoot()
    * @generated
    */
   EReference getDocumentRoot_XSISchemaLocation();

   /**
    * Returns the meta object for the containment reference '{@link org.eclipse.stp.core.tests.props.DocumentRoot#getImplementationProperties <em>Implementation Properties</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the containment reference '<em>Implementation Properties</em>'.
    * @see org.eclipse.stp.core.tests.props.DocumentRoot#getImplementationProperties()
    * @see #getDocumentRoot()
    * @generated
    */
   EReference getDocumentRoot_ImplementationProperties();

   /**
    * Returns the meta object for class '{@link org.eclipse.stp.core.tests.props.PropertiesImplementation <em>Properties Implementation</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for class '<em>Properties Implementation</em>'.
    * @see org.eclipse.stp.core.tests.props.PropertiesImplementation
    * @generated
    */
   EClass getPropertiesImplementation();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.tests.props.PropertiesImplementation#getAny <em>Any</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any</em>'.
    * @see org.eclipse.stp.core.tests.props.PropertiesImplementation#getAny()
    * @see #getPropertiesImplementation()
    * @generated
    */
   EAttribute getPropertiesImplementation_Any();

   /**
    * Returns the meta object for the attribute '{@link org.eclipse.stp.core.tests.props.PropertiesImplementation#getProperties <em>Properties</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute '<em>Properties</em>'.
    * @see org.eclipse.stp.core.tests.props.PropertiesImplementation#getProperties()
    * @see #getPropertiesImplementation()
    * @generated
    */
   EAttribute getPropertiesImplementation_Properties();

   /**
    * Returns the meta object for the attribute list '{@link org.eclipse.stp.core.tests.props.PropertiesImplementation#getAnyAttribute <em>Any Attribute</em>}'.
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the meta object for the attribute list '<em>Any Attribute</em>'.
    * @see org.eclipse.stp.core.tests.props.PropertiesImplementation#getAnyAttribute()
    * @see #getPropertiesImplementation()
    * @generated
    */
   EAttribute getPropertiesImplementation_AnyAttribute();

   /**
    * Returns the factory that creates the instances of the model. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @return the factory that creates the instances of the model.
    * @generated
    */
   PropsFactory getPropsFactory();

} // PropsPackage
