/**
 * <copyright> </copyright>
 * 
 * $Id: PropsAdapterFactory.java,v 1.1 2006-03-31 21:58:53 melder Exp $
 */
package org.eclipse.stp.core.tests.properties.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.tests.properties.DocumentRoot;
import org.eclipse.stp.core.tests.properties.PropertiesImplementation;
import org.eclipse.stp.core.tests.properties.PropsPackage;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory</b> for the model. It
 * provides an adapter <code>createXXX</code> method for each class of the
 * model. <!-- end-user-doc -->
 * 
 * @see org.eclipse.stp.core.tests.props.PropsPackage
 * @generated
 */
public class PropsAdapterFactory extends AdapterFactoryImpl {
   /**
    * The cached model package. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected static PropsPackage modelPackage;

   /**
    * Creates an instance of the adapter factory. <!-- begin-user-doc --> <!--
    * end-user-doc -->
    * 
    * @generated
    */
   public PropsAdapterFactory() {
      if (modelPackage == null) {
         modelPackage = PropsPackage.eINSTANCE;
      }
   }

   /**
    * Returns whether this factory is applicable for the type of the object.
    * <!-- begin-user-doc --> This implementation returns <code>true</code> if
    * the object is either the model's package or is an instance object of the
    * model. <!-- end-user-doc -->
    * 
    * @return whether this factory is applicable for the type of the object.
    * @generated
    */
   public boolean isFactoryForType(Object object) {
      if (object == modelPackage) {
         return true;
      }
      if (object instanceof EObject) {
         return ((EObject) object).eClass().getEPackage() == modelPackage;
      }
      return false;
   }

   /**
    * The switch the delegates to the <code>createXXX</code> methods. <!--
    * begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   protected PropsSwitch modelSwitch = new PropsSwitch() {
                                        public Object caseDocumentRoot(
                                              DocumentRoot object) {
                                           return createDocumentRootAdapter();
                                        }

                                        public Object casePropertiesImplementation(
                                              PropertiesImplementation object) {
                                           return createPropertiesImplementationAdapter();
                                        }

                                        public Object caseImplementation(
                                              Implementation object) {
                                           return createImplementationAdapter();
                                        }

                                        public Object defaultCase(EObject object) {
                                           return createEObjectAdapter();
                                        }
                                     };

   /**
    * Creates an adapter for the <code>target</code>. <!-- begin-user-doc -->
    * <!-- end-user-doc -->
    * 
    * @param target
    *           the object to adapt.
    * @return the adapter for the <code>target</code>.
    * @generated
    */
   public Adapter createAdapter(Notifier target) {
      return (Adapter) modelSwitch.doSwitch((EObject) target);
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.tests.props.DocumentRoot <em>Document Root</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.tests.props.DocumentRoot
    * @generated
    */
   public Adapter createDocumentRootAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.tests.props.PropertiesImplementation <em>Properties Implementation</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.tests.props.PropertiesImplementation
    * @generated
    */
   public Adapter createPropertiesImplementationAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for an object of class '{@link org.eclipse.stp.core.sca.Implementation <em>Implementation</em>}'.
    * <!-- begin-user-doc --> This default implementation returns null so that
    * we can easily ignore cases; it's useful to ignore a case when inheritance
    * will catch all the cases anyway. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @see org.eclipse.stp.core.sca.Implementation
    * @generated
    */
   public Adapter createImplementationAdapter() {
      return null;
   }

   /**
    * Creates a new adapter for the default case. <!-- begin-user-doc --> This
    * default implementation returns null. <!-- end-user-doc -->
    * 
    * @return the new adapter.
    * @generated
    */
   public Adapter createEObjectAdapter() {
      return null;
   }

} // PropsAdapterFactory
