/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.infrastructure.emf.DefaultScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;

public class TestDomain extends DefaultScribblerDomain implements
      IScribblerDomain {

   private static final IPath    defaultLocation = new Path(
                                                       "META-INF/ejb-jar.xml"); //$NON-NLS-1$

   private IContainer            container;

   private IResourceDescriptor[] descriptors;

   private URI                   testURI;

   private IResourceDescriptor   testDescriptor;

   public static TestDomain createTestDomain(IProject aProject) {
      return new TestDomain(aProject.getFolder("ejbModule")); //$NON-NLS-1$
   }

   public TestDomain(IContainer aContainer) {
      container = aContainer;
      testURI = URI.createPlatformResourceURI(container.getFullPath().append(
            defaultLocation).toString());

      testDescriptor = new EclipseResourceDescriptor(defaultLocation, container
            .getFile(defaultLocation).getFullPath());
      descriptors = new IResourceDescriptor[] { testDescriptor };

   }

   public IResourceDescriptor[] getResourceDescriptors() {

      return descriptors;
   }

   public String getLabel() {
      return "EJB Deployment Descriptor Domain"; //$NON-NLS-1$
   }

   public URI getTestURI() {
      return testURI;
   }

   public IPath getTestPath() {
      return container.getFullPath().append(defaultLocation);
   }

   public String getEditModelLabel() {
      return container.getProject().getName() + ".test.ejb.editmodel"; //$NON-NLS-1$
   }

   public IResourceDescriptor getTestDescriptor() {
      return testDescriptor;
   }

}
