/*******************************************************************************
 * Copyright (c) 2003, 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.ejb.EJBJar;

public class TestOperationArgs implements IAdaptable {

   private String newDisplayName;

   private EJBJar ejbJar;

   public TestOperationArgs(String aNewDisplayName, EJBJar anEJBJar) {
      newDisplayName = aNewDisplayName;
      ejbJar = anEJBJar;
   }

   public TestOperationArgs(TestOperationArgs cloneArgs) {
      newDisplayName = cloneArgs.newDisplayName;
      ejbJar = cloneArgs.ejbJar;
   }

   public Object getAdapter(Class adapter) {
      if (adapter == TestOperationArgs.class)
         return this;
      return null;
   }

   public EJBJar getEjbJar() {
      return ejbJar;
   }

   public void setEjbJar(EJBJar ejbJar) {
      this.ejbJar = ejbJar;
   }

   public String getNewDisplayName() {
      return newDisplayName;
   }

   public void setNewDisplayName(String newDisplayName) {
      this.newDisplayName = newDisplayName;
   }

}
