/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jdom.input.SAXBuilder;

public class XMLEditDialog
extends Dialog {
    static boolean interactive = true;
    private final String rootName;
    private final String initialXML;
    private String xml;
    Text xmlTxt;

    public XMLEditDialog(Shell shell, String initial) {
        this(shell, initial, null);
    }

    public XMLEditDialog(Shell shell, String initial, String multiRootName) {
        super(shell);
        this.setShellStyle(67696);
        this.initialXML = initial;
        this.rootName = multiRootName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enter XML");
        newShell.setMinimumSize(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.xmlTxt = new Text(composite, 2818);
        this.xmlTxt.setLayoutData((Object)new GridData(1808));
        this.xmlTxt.setText(this.initialXML);
        return composite;
    }

    public String getXML() {
        return this.xml;
    }

    protected void okPressed() {
        SAXBuilder builder = new SAXBuilder();
        String toParse = this.rootName != null ? "<" + this.rootName + ">" + this.xmlTxt.getText() + "</" + this.rootName + ">" : this.xmlTxt.getText();
        try {
            builder.build((InputStream)new ByteArrayInputStream(toParse.getBytes()));
            this.xml = this.xmlTxt.getText();
            super.okPressed();
        }
        catch (Exception e) {
            if (interactive) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error parsing XML", (String)("There was an error parsing the XML: " + e.getMessage()));
            }
            this.xml = null;
        }
    }
}

