/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stp.ui.xef.PluginResources;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.editor.AbstractFieldEditor;
import org.eclipse.stp.ui.xef.editor.BooleanCheckControlAccessor;
import org.eclipse.stp.ui.xef.editor.BooleanControlAcccessor;
import org.eclipse.stp.ui.xef.editor.ComboControlAccessor;
import org.eclipse.stp.ui.xef.editor.ControlAccessor;
import org.eclipse.stp.ui.xef.editor.FieldEditorRegistry;
import org.eclipse.stp.ui.xef.editor.FilterRegistry;
import org.eclipse.stp.ui.xef.editor.IXefDetailsPage;
import org.eclipse.stp.ui.xef.editor.PasswordControlAccessor;
import org.eclipse.stp.ui.xef.editor.QNameControlAccessor;
import org.eclipse.stp.ui.xef.editor.QNameFieldEditor;
import org.eclipse.stp.ui.xef.editor.SimpleHashFilter;
import org.eclipse.stp.ui.xef.editor.SpinnerControlAccessor;
import org.eclipse.stp.ui.xef.editor.TextControlAccessor;
import org.eclipse.stp.ui.xef.editor.TextFieldVerifyListener;
import org.eclipse.stp.ui.xef.editor.XMLEditDialog;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefEditMasterDetailsBlock;
import org.eclipse.stp.ui.xef.editor.XefEditor;
import org.eclipse.stp.ui.xef.help.XefHelpView;
import org.eclipse.stp.ui.xef.schema.AnnotatedElement;
import org.eclipse.stp.ui.xef.schema.AnyElement;
import org.eclipse.stp.ui.xef.schema.SchemaAttribute;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.ValueType;
import org.eclipse.stp.ui.xef.schema.WidgetType;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.eclipse.stp.xef.util.QNameHelper;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.jdom.Attribute;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XefDetailsPage
implements IDetailsPage,
IXefDetailsPage {
    private static final String DEFAULT_CAT_NAME = "Main";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern NCNAME_PATTERN = Pattern.compile("([a-zA-Z_])([a-zA-Z0-9-_:\\.])*");
    static final String DEFAULT_TOOLITEM_BUTTON = "Default Button";
    static final String ACCESSOR = "Control Accessor";
    static final String CONTROLS = "The actual controls";
    static final String FIXED = "Fixed";
    static final String LABEL = "Label";
    static final String PREV_VALUE = "Previous value";
    static final String UNITS = "Units";
    static final String NS_MAPPINGS = "Namespace Mappings";
    static boolean interactive = true;
    final XMLInstanceElement element;
    final Map<Control, Object> values = new HashMap<Control, Object>();
    boolean dirty = false;
    private final XefEditor editor;
    private IManagedForm managedForm;
    private Listener modifyListener;

    public XefDetailsPage(XefEditor ed, XMLInstanceElement el) {
        this.editor = ed;
        this.element = el;
    }

    public void initialize(IManagedForm form) {
        this.managedForm = form;
    }

    public void createContents(final Composite parent) {
        this.modifyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Control) {
                    XefDetailsPage.this.markDirty((Control)event.widget);
                }
            }
        };
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.managedForm.getToolkit();
        Section s1 = toolkit.createSection(parent, 384);
        s1.marginWidth = 10;
        s1.setText("Policy Values");
        s1.setDescription("Element: " + XefEditMasterDetailsBlock.getLabel(this.element));
        s1.setLayout((Layout)new GridLayout(1, false));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        s1.setLayoutData((Object)td);
        List<String> categoryNames = this.getFurtherSections();
        LinkedHashMap<String, Composite> categories = new LinkedHashMap<String, Composite>();
        Composite holder = toolkit.createComposite((Composite)s1);
        GridLayout glayout = new GridLayout();
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.numColumns = 1;
        holder.setLayout((Layout)glayout);
        Composite mainContents = this.createMainAttributeSection(toolkit, holder);
        categories.put(DEFAULT_CAT_NAME, mainContents);
        for (String categoryName : categoryNames) {
            Section ec = toolkit.createSection(holder, 18);
            ec.setText(categoryName);
            ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    Composite grandParent = parent.getParent().getParent();
                    if (grandParent instanceof SharedScrolledComposite) {
                        ((SharedScrolledComposite)grandParent).reflow(true);
                    }
                }
            });
            Composite contents = toolkit.createComposite((Composite)ec);
            GridLayout gl = new GridLayout();
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.numColumns = 4;
            contents.setLayout((Layout)gl);
            ec.setClient((Control)contents);
            categories.put(categoryName, contents);
        }
        s1.setClient((Control)holder);
        this.createAttributeControls(toolkit, categories);
        this.createAnyContentControls(toolkit, mainContents);
        this.createTextAreaControls(toolkit, mainContents);
    }

    private Composite createMainAttributeSection(FormToolkit toolkit, Composite composite) {
        Composite contents = toolkit.createComposite(composite);
        GridLayout glayout = new GridLayout();
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        glayout.numColumns = 4;
        contents.setLayout((Layout)glayout);
        Composite sep = new Composite(contents, 0);
        sep.setBackground(contents.getBackground());
        sep.setLayout((Layout)new RowLayout());
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        sep.setLayoutData((Object)gd);
        return contents;
    }

    private void createTextAreaControls(FormToolkit toolkit, Composite parent) {
        if (!this.element.getTemplate().hasText()) {
            return;
        }
        if (this.element.getTemplate().isSequenceOfAny()) {
            return;
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        Label l = toolkit.createLabel(parent, "Value:");
        l.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 70;
        gd.horizontalIndent = 5;
        gd.verticalIndent = 5;
        Text t = toolkit.createText(parent, "", 66);
        t.setLayoutData((Object)gd);
        t.setData(ACCESSOR, (Object)new TextControlAccessor(t));
        t.setData(CONTROLS, (Object)new Control[]{t});
        t.setData(LABEL, (Object)l);
        t.addListener(24, this.modifyListener);
        this.values.put((Control)t, this.element.getTemplate());
        toolkit.createLabel(parent, "");
        toolkit.createLabel(parent, "");
    }

    private void createAnyContentControls(FormToolkit toolkit, Composite parent) {
        if (!this.element.getTemplate().isSequenceOfAny()) {
            return;
        }
        AnyElement anyElement = this.element.getTemplate().getAnySequenceElement();
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        Label l = toolkit.createLabel(parent, String.valueOf(anyElement.getDisplayName()) + ":");
        String toolTipText = this.normalizeTooltipText(anyElement);
        l.setToolTipText(toolTipText);
        l.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.widthHint = 250;
        gd.heightHint = 250;
        gd.horizontalIndent = 5;
        gd.verticalIndent = 5;
        final Text t = toolkit.createText(parent, "", 778);
        t.setLayoutData((Object)gd);
        t.setToolTipText(toolTipText);
        t.setEnabled(false);
        TextControlAccessor tca = new TextControlAccessor(t);
        t.setData(ACCESSOR, (Object)tca);
        t.setData(CONTROLS, (Object)new Control[]{t});
        t.setData(LABEL, (Object)l);
        this.values.put((Control)t, this.element.getTemplate());
        tca.setValue(this.element.getEmbeddedXML());
        t.addListener(24, this.modifyListener);
        t.addFocusListener((FocusListener)new HelpViewSynchingFocusListener(anyElement));
        Button editBtn = toolkit.createButton(parent, "...", 8);
        gd = new GridData(2);
        gd.verticalIndent = 5;
        editBtn.setLayoutData((Object)gd);
        editBtn.setToolTipText("Click to edit the XML content");
        editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XMLEditDialog dlg = new XMLEditDialog(XefDetailsPage.this.editor.getSite().getShell(), t.getText(), XefDetailsPage.this.element.getTemplate().getName());
                if (dlg.open() == 0) {
                    t.setText(dlg.getXML());
                }
            }
        });
    }

    private List<String> getFurtherSections() {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (SchemaAttribute attr : this.element.getTemplate().getAttributes()) {
            String category = attr.getCategory();
            if (category == null) continue;
            s.add(category);
        }
        return new ArrayList<String>(s);
    }

    private void createAttributeControls(FormToolkit toolkit, Map<String, Composite> categories) {
        for (SchemaAttribute attr : this.element.getTemplate().getAttributes()) {
            try {
                String category = attr.getCategory();
                Composite parent = categories.get(category != null ? category : DEFAULT_CAT_NAME);
                if (parent == null) continue;
                Label label = toolkit.createLabel(parent, String.valueOf(attr.getDisplayName()) + ":");
                label.setToolTipText(this.normalizeTooltipText(attr));
                label.setLayoutData((Object)new GridData(512));
                Control control = this.createControl(attr, parent, toolkit);
                control.setData(LABEL, (Object)label);
                this.values.put(control, attr);
                if (attr.getWidget() != WidgetType.PASSWORD) continue;
                this.addSecondaryPasswordControl(attr, control, parent, toolkit);
            }
            catch (CoreException e) {
                e.printStackTrace();
                XefPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    private void addSecondaryPasswordControl(SchemaAttribute attr, Control pwdCtrl1, Composite parent, FormToolkit toolkit) throws CoreException {
        Text pwText1 = null;
        if (pwdCtrl1 instanceof Text) {
            pwText1 = (Text)pwdCtrl1;
        }
        PasswordControlAccessor pca = null;
        if (pwText1.getData(ACCESSOR) instanceof PasswordControlAccessor) {
            pca = (PasswordControlAccessor)pwText1.getData(ACCESSOR);
        }
        toolkit.createLabel(parent, "Confirm:");
        Control pwdCtrl2 = this.createControlWidgets(attr, parent, toolkit);
        toolkit.createLabel(parent, "");
        toolkit.createLabel(parent, "");
        Text pwText2 = null;
        if (pwdCtrl2 instanceof Text) {
            pwText2 = (Text)pwdCtrl2;
        }
        if (pwText1 == null || pwText2 == null || pca == null) {
            MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)"Could not create password control", (String)"An unexpected error occurred when creating a password control");
            return;
        }
        pca.setSecondaryText(pwText2);
        pwText2.setText(pwText1.getText());
        Control[] controls = (Control[])pwdCtrl1.getData(CONTROLS);
        Control[] newControls = new Control[controls.length + 1];
        System.arraycopy(controls, 0, newControls, 0, controls.length);
        newControls[controls.length] = pwdCtrl2;
        pwdCtrl1.setData(CONTROLS, (Object)newControls);
        Text pwt1 = pwText1;
        final Text pwt2 = pwText2;
        pwt1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                pwt2.setFocus();
                XefDetailsPage.this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        pwt2.setFocus();
                    }
                });
            }
        });
    }

    private Control createControl(SchemaAttribute attr, Composite container, FormToolkit toolkit) throws CoreException {
        Control[] controls;
        String curValue = this.element.getAttribute(attr.getName());
        Control logicalControl = this.createControlWidgets(attr, container, toolkit);
        if (curValue != null) {
            ControlAccessor accessor = (ControlAccessor)logicalControl.getData(ACCESSOR);
            accessor.setValue(curValue);
            logicalControl.setData(PREV_VALUE, (Object)curValue);
        }
        if (attr.getFixed() != null) {
            this.setFixedValue(logicalControl, attr.getFixed());
        }
        String units = attr.getUnits() == null ? "" : "(" + attr.getUnits() + ")";
        Label unitLabel = toolkit.createLabel(container, units);
        logicalControl.setData(UNITS, (Object)unitLabel);
        if (!attr.getRequired() && attr.getFixed() == null) {
            this.addDefaultButton(toolkit, container, logicalControl, curValue, attr.getDefault());
        } else {
            this.addEmptyButton(toolkit, container);
        }
        if (attr.getRequired() && curValue == null && attr.getExample() != null) {
            ((ControlAccessor)logicalControl.getData(ACCESSOR)).setValue(attr.getExample());
            this.markDirty(logicalControl);
        }
        Control[] controlArray = controls = (Control[])logicalControl.getData(CONTROLS);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button) {
                control.addListener(13, this.modifyListener);
            } else {
                control.addListener(24, this.modifyListener);
            }
            if (attr.getPattern() != null) {
                TypedListener verifyListener = new TypedListener((SWTEventListener)new TextFieldVerifyListener(attr.getPattern()));
                control.addListener(25, (Listener)verifyListener);
            }
            if (attr.getContextXPath() != null) {
                String xpath = attr.getContextXPath();
                this.addContextListener(control, xpath);
            }
            if (control.getToolTipText() == null) {
                control.setToolTipText(this.normalizeTooltipText(attr));
            }
            control.addFocusListener((FocusListener)new HelpViewSynchingFocusListener(attr));
            ++n2;
        }
        return logicalControl;
    }

    private void addDefaultButton(FormToolkit toolkit, Composite container, final Control logicalControl, String value, String def) {
        Control control;
        int n;
        int n2;
        Control[] controlArray;
        final String defaultValue = def == null ? "" : def;
        final Control[] controls = (Control[])logicalControl.getData(CONTROLS);
        final ControlAccessor accessor = (ControlAccessor)logicalControl.getData(ACCESSOR);
        final ToolItem defaultToolitem = this.createDefaultButton(toolkit, container);
        final Color activeColor = controls[0].getForeground();
        final Color inActiveColor = controls[0].getDisplay().getSystemColor(15);
        logicalControl.setData(DEFAULT_TOOLITEM_BUTTON, (Object)defaultToolitem);
        if (value == null || value.length() == 0) {
            controlArray = controls;
            n2 = controls.length;
            n = 0;
            while (n < n2) {
                control = controlArray[n];
                control.setForeground(inActiveColor);
                ++n;
            }
            accessor.setValue(defaultValue);
            defaultToolitem.setSelection(true);
            defaultToolitem.setImage(XefPlugin.getDefault().getImageRegistry().get("default"));
        } else {
            defaultToolitem.setSelection(false);
            defaultToolitem.setImage(XefPlugin.getDefault().getImageRegistry().get("default_off"));
        }
        defaultToolitem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Control[] controlArray = controls;
                int n = controls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setForeground(defaultToolitem.getSelection() ? inActiveColor : activeColor);
                    ++n2;
                }
                if (defaultToolitem.getSelection()) {
                    String curVal = accessor.getValue();
                    accessor.setValue(defaultValue);
                    logicalControl.setData(XefDetailsPage.PREV_VALUE, (Object)curVal);
                    defaultToolitem.setImage(XefPlugin.getDefault().getImageRegistry().get("default"));
                    ((XefDetailsPage)XefDetailsPage.this).editor.policyEditPage.block.getViewer().getTree().setFocus();
                } else {
                    Object prev = logicalControl.getData(XefDetailsPage.PREV_VALUE);
                    if (prev != null) {
                        accessor.setValue(prev.toString());
                    } else {
                        accessor.setValue("");
                    }
                    defaultToolitem.setImage(XefPlugin.getDefault().getImageRegistry().get("default_off"));
                }
            }
        });
        controlArray = controls;
        n2 = controls.length;
        n = 0;
        while (n < n2) {
            control = controlArray[n];
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (defaultToolitem.getSelection()) {
                        defaultToolitem.setSelection(false);
                        defaultToolitem.notifyListeners(13, new Event());
                    }
                }
            });
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (defaultToolitem.getSelection()) {
                        defaultToolitem.setSelection(false);
                        defaultToolitem.notifyListeners(13, new Event());
                    }
                }
            });
            ++n;
        }
    }

    private ToolItem createDefaultButton(FormToolkit toolkit, Composite container) {
        ToolBar tb = new ToolBar(container, 0x800000);
        tb.setBackground(container.getBackground());
        tb.setForeground(container.getForeground());
        ToolItem ti = new ToolItem(tb, 32);
        ti.setToolTipText("Toggle default value");
        return ti;
    }

    private void addEmptyButton(FormToolkit toolkit, Composite container) {
        ToolItem btn = this.createDefaultButton(toolkit, container);
        btn.getParent().setVisible(false);
    }

    private void setFixedValue(Control logicalControl, String value) {
        ControlAccessor accessor = (ControlAccessor)logicalControl.getData(ACCESSOR);
        accessor.setValue(value);
        logicalControl.setData(FIXED, (Object)FIXED);
    }

    private Control createControlWidgets(SchemaAttribute attr, Composite parent, FormToolkit toolkit) throws CoreException {
        Control logicalControl = this.createControlWidgets2(attr, parent, toolkit);
        GridData gd = new GridData();
        if (this.isNumeric(attr.getValue().getType())) {
            gd.widthHint = 50;
            gd.horizontalAlignment = 0x1000008;
            gd.grabExcessHorizontalSpace = false;
        } else if (logicalControl instanceof Text && (((Text)logicalControl).getStyle() & 2) > 0) {
            gd.horizontalSpan = 2;
            gd.heightHint = 150;
            gd.widthHint = 400;
            gd.horizontalAlignment = 4;
            gd.grabExcessVerticalSpace = false;
        } else {
            gd.minimumWidth = 150;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 150;
        }
        logicalControl.setLayoutData((Object)gd);
        return logicalControl;
    }

    private boolean isNumeric(ValueType type) {
        switch (type) {
            case INTEGER: 
            case SHORT: 
            case BYTE: 
            case UINT: 
            case USHORT: 
            case UBYTE: 
            case NEGATIVE_INT: 
            case POSITIVE_INT: 
            case NON_NEGATIVE_INT: 
            case NON_POSITIVE_INT: {
                return true;
            }
        }
        return false;
    }

    private Control createControlWidgets2(SchemaAttribute attr, Composite parent, FormToolkit toolkit) throws CoreException {
        String[] values;
        XMLProviderEditorInput editorInput;
        boolean enabled = attr.getFixed() == null;
        switch (attr.getValue().getType()) {
            case ENUMERATION: {
                String[] allowed = attr.getValue().getAllowedValues().toArray(new String[0]);
                return this.createCombo(attr, allowed, enabled, parent, toolkit);
            }
            case BOOLEAN: {
                if (attr.getWidget() == WidgetType.CHECK) {
                    Button booleanCheckButton = toolkit.createButton(parent, "", 32);
                    booleanCheckButton.setEnabled(enabled);
                    booleanCheckButton.setData(ACCESSOR, (Object)new BooleanCheckControlAccessor(booleanCheckButton));
                    booleanCheckButton.setData(CONTROLS, (Object)new Control[]{booleanCheckButton});
                    return booleanCheckButton;
                }
                Composite container = toolkit.createComposite(parent);
                container.setLayout((Layout)new RowLayout(256));
                Button trueButton = toolkit.createButton(container, "True", 16);
                Button falseButton = toolkit.createButton(container, "False", 16);
                trueButton.setEnabled(enabled);
                falseButton.setEnabled(enabled);
                container.setEnabled(enabled);
                toolkit.paintBordersFor(container);
                container.setData(Boolean.TRUE.toString(), (Object)trueButton);
                container.setData(Boolean.FALSE.toString(), (Object)falseButton);
                container.setData(ACCESSOR, (Object)new BooleanControlAcccessor(container));
                container.setData(CONTROLS, (Object)new Control[]{trueButton, falseButton});
                return container;
            }
            case UINT: 
            case USHORT: 
            case UBYTE: 
            case POSITIVE_INT: 
            case NON_NEGATIVE_INT: {
                return this.createSpinnerControl(attr, enabled, parent, toolkit);
            }
            case QNAME: {
                return this.createQNameControl(attr, enabled, parent, toolkit);
            }
            case NCNAME: {
                attr.setPattern(NCNAME_PATTERN.toString());
            }
        }
        if (attr.getWidget() == WidgetType.PASSWORD) {
            return this.createPasswordControl(attr, parent, toolkit);
        }
        if (this.editor.getEditorInput() instanceof XMLProviderEditorInput && (editorInput = (XMLProviderEditorInput)this.editor.getEditorInput()).getContextProvider() != null && (values = attr.getContextValues(editorInput.getContextProvider(), this.element.getDependencyValue(attr.getContextXPath()))) != null) {
            return this.createCombo(attr, values, enabled, parent, toolkit);
        }
        boolean multiline = attr.getWidget() == WidgetType.MULTILINE;
        return this.createPlainTextControl(attr, enabled, multiline, parent, toolkit);
    }

    public void dispose() {
    }

    void markDirty(Control control) {
        this.setDirty(true);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean value) {
        this.dirty = value;
        this.managedForm.dirtyStateChanged();
        if (this.dirty) {
            this.editor.fireSaveNeeded();
        }
    }

    public void commit(boolean onSave) {
        for (Control control : this.values.keySet()) {
            this.storeControlInJDomElement(control);
        }
    }

    private void storeControlInJDomElement(Control control) {
        Object schemaType = this.values.get(control);
        if (schemaType instanceof SchemaAttribute) {
            String name = ((SchemaAttribute)schemaType).getName();
            ToolItem defBtn = (ToolItem)control.getData(DEFAULT_TOOLITEM_BUTTON);
            if (defBtn != null && defBtn.getSelection() || control.getData(FIXED) != null) {
                this.element.removeAttribute(name);
            } else {
                this.element.setAttribute(name, this.getValue(control));
            }
        } else if (schemaType instanceof SchemaElement) {
            if (((SchemaElement)schemaType).isSequenceOfAny()) {
                this.element.setEmbeddedXML(this.getValue(control));
            } else {
                this.element.setText(this.getValue(control));
            }
        }
    }

    private String getValue(Control control) {
        ControlAccessor accessor = (ControlAccessor)control.getData(ACCESSOR);
        return accessor.getValue();
    }

    public Map<Control, Object> getValues() {
        return this.values;
    }

    private void updateValues(Control control, String filterValue) {
        String[] newValues;
        XMLProviderEditorInput editorInput;
        if (!(this.values.get(control) instanceof SchemaAttribute) || !(control instanceof Combo)) {
            return;
        }
        boolean needsUpdating = false;
        Combo combo = (Combo)control;
        String[] oldValues = combo.getItems();
        String oldValue = ((ControlAccessor)control.getData(ACCESSOR)).getValue();
        SchemaAttribute attr = (SchemaAttribute)this.values.get(control);
        if (this.editor.getEditorInput() instanceof XMLProviderEditorInput && (editorInput = (XMLProviderEditorInput)this.editor.getEditorInput()).getContextProvider() != null && (newValues = attr.getContextValues(editorInput.getContextProvider(), filterValue)) != null) {
            if (newValues.length != oldValues.length) {
                needsUpdating = true;
            } else {
                if (combo.getData(ACCESSOR) instanceof QNameControlAccessor) {
                    newValues = ((QNameControlAccessor)combo.getData(ACCESSOR)).getQNameValues(newValues);
                }
                int i = 0;
                while (i < newValues.length) {
                    if (!newValues[i].equals(oldValues[i])) {
                        needsUpdating = true;
                        break;
                    }
                    ++i;
                }
            }
            if (needsUpdating) {
                combo.setItems(newValues);
                combo.select(combo.indexOf(oldValue));
                combo.notifyListeners(13, new Event());
            }
        }
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void setFocus() {
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        for (Control control : this.values.keySet()) {
            SchemaAttribute attr;
            Object object = this.values.get(control);
            if (!(object instanceof SchemaAttribute) || (attr = (SchemaAttribute)object).getContextXPath() == null) continue;
            String filter = this.element.getDependencyValue(attr.getContextXPath());
            this.updateValues(control, filter);
        }
    }

    public void selectionChanged(IFormPart part, ISelection sel) {
        this.refresh();
    }

    private Combo createCombo(SchemaAttribute attr, String[] values, boolean enabled, Composite parent, FormToolkit toolkit) {
        int style = 0x800004;
        if (attr.getWidget() != WidgetType.READ_WRITE) {
            style |= 8;
        }
        Combo combo = new Combo(parent, style);
        toolkit.adapt((Control)combo, true, true);
        combo.setEnabled(enabled);
        combo.setData(ACCESSOR, (Object)new ComboControlAccessor(combo));
        combo.setData(CONTROLS, (Object)new Control[]{combo});
        if (values != null && values.length > 0) {
            combo.setItems(values);
            combo.setData(PREV_VALUE, (Object)values[0]);
        }
        toolkit.paintBordersFor(parent);
        return combo;
    }

    private Control createSpinnerControl(SchemaAttribute attr, boolean enabled, Composite parent, FormToolkit toolkit) {
        Spinner spinner = new Spinner(parent, 64);
        switch (attr.getValue().getType()) {
            case INTEGER: {
                spinner.setMinimum(Integer.MIN_VALUE);
                spinner.setMaximum(Integer.MAX_VALUE);
                break;
            }
            case SHORT: {
                spinner.setMinimum(Short.MIN_VALUE);
                spinner.setMaximum(Short.MAX_VALUE);
                break;
            }
            case BYTE: {
                spinner.setMinimum(-128);
                spinner.setMaximum(127);
                break;
            }
            case UINT: {
                spinner.setMinimum(0);
                spinner.setMaximum(Integer.MAX_VALUE);
                break;
            }
            case USHORT: {
                spinner.setMinimum(0);
                spinner.setMaximum(65535);
                break;
            }
            case UBYTE: {
                spinner.setMinimum(0);
                spinner.setMaximum(255);
                break;
            }
            case NEGATIVE_INT: {
                spinner.setMinimum(Integer.MIN_VALUE);
                spinner.setMaximum(-1);
                break;
            }
            case POSITIVE_INT: {
                spinner.setMinimum(1);
                spinner.setMaximum(Integer.MAX_VALUE);
                break;
            }
            case NON_NEGATIVE_INT: {
                spinner.setMinimum(0);
                spinner.setMaximum(Integer.MAX_VALUE);
                break;
            }
            case NON_POSITIVE_INT: {
                spinner.setMinimum(Integer.MIN_VALUE);
                spinner.setMaximum(0);
            }
        }
        toolkit.adapt((Control)spinner, true, true);
        spinner.setEnabled(enabled);
        spinner.setData(ACCESSOR, (Object)new SpinnerControlAccessor(spinner));
        spinner.setData(CONTROLS, (Object)new Control[]{spinner});
        return spinner;
    }

    private Text createPasswordControl(SchemaAttribute attr, Composite parent, FormToolkit toolkit) throws CoreException {
        Text text = toolkit.createText(parent, "", 0x400004);
        SimpleHashFilter filter = attr.getFilterId() != null ? FilterRegistry.getFilter(attr.getFilterId()) : SimpleHashFilter.SINGLETON;
        text.setData(ACCESSOR, (Object)new PasswordControlAccessor(text, filter));
        text.setData(CONTROLS, (Object)new Control[]{text});
        return text;
    }

    private Combo createQNameControl(SchemaAttribute attr, boolean enabled, Composite parent, FormToolkit toolkit) throws CoreException {
        XMLProviderEditorInput editorInput;
        Composite qname = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.numColumns = 2;
        gl.horizontalSpacing = 0;
        qname.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        qname.setLayoutData((Object)gd);
        int style = 0x80000C;
        final Combo combo = new Combo(qname, style);
        toolkit.adapt((Control)combo, true, true);
        combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        combo.setEnabled(enabled);
        String[] values = new String[]{};
        if (this.editor.getEditorInput() instanceof XMLProviderEditorInput && (editorInput = (XMLProviderEditorInput)this.editor.getEditorInput()).getContextProvider() != null) {
            values = attr.getContextValues(editorInput.getContextProvider(), this.element.getDependencyValue(attr.getContextXPath()));
        }
        Map<String, String> namespaceMap = QNameControlAccessor.createNamespaceMap(this.element.getNamespaceMap(), values);
        QNameControlAccessor accessor = new QNameControlAccessor(combo, namespaceMap);
        combo.setData(NS_MAPPINGS, namespaceMap);
        combo.setData(ACCESSOR, (Object)accessor);
        combo.setData(CONTROLS, (Object)new Control[]{combo});
        if (values != null && values.length > 0) {
            String[] displayValues = accessor.getQNameValues(values);
            combo.setItems(displayValues);
            combo.setData(PREV_VALUE, (Object)displayValues[0]);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo combo = (Combo)event.widget;
                QNameControlAccessor accessor = (QNameControlAccessor)combo.getData(XefDetailsPage.ACCESSOR);
                XefDetailsPage.this.updateQNameNamespaceDecl((Control)combo);
                String selItem = combo.getText();
                combo.setData(XefDetailsPage.PREV_VALUE, (Object)selItem);
                combo.setToolTipText(accessor.convertToFullName(selItem));
            }
        });
        if (attr.getWidget() != WidgetType.READ_ONLY) {
            gl.horizontalSpacing = 5;
            qname.setLayout((Layout)gl);
            final QNameFieldEditor fieldEditor = attr.getFieldEditorId() != null ? FieldEditorRegistry.getFieldEditor(attr.getFieldEditorId()) : QNameFieldEditor.SINGLETON;
            fieldEditor.setFieldData(namespaceMap);
            Button button = toolkit.createButton(qname, PluginResources.getString("fieldEditor.lbl"), 8);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ControlAccessor accessor = (ControlAccessor)combo.getData(XefDetailsPage.ACCESSOR);
                    String newQName = fieldEditor.getNewValue(accessor.getValue());
                    if (newQName != null) {
                        accessor.setValue(newQName);
                        combo.notifyListeners(24, new Event());
                    }
                }
            });
        }
        toolkit.paintBordersFor(parent);
        return combo;
    }

    private Text createPlainTextControl(SchemaAttribute attr, boolean enabled, boolean multiline, Composite parent, FormToolkit toolkit) throws CoreException {
        int style;
        Composite textComp;
        if (attr.getFieldEditorId() != null) {
            textComp = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.numColumns = 2;
            textComp.setLayout((Layout)gl);
            GridData gd = new GridData(1808);
            textComp.setLayoutData((Object)gd);
        } else {
            textComp = parent;
        }
        if (multiline) {
            style = 2818;
            new Label(textComp, 0);
            new Label(textComp, 0);
            new Label(textComp, 0);
        } else {
            style = 4;
        }
        final Text text = toolkit.createText(textComp, "", style);
        text.setEnabled(enabled);
        text.setData(ACCESSOR, (Object)new TextControlAccessor(text));
        text.setData(CONTROLS, (Object)new Control[]{text});
        if (attr.getFieldEditorId() != null) {
            XMLProviderEditorInput editorInput;
            final AbstractFieldEditor fieldEditor = FieldEditorRegistry.getFieldEditor(attr.getFieldEditorId());
            if (this.editor.getEditorInput() instanceof XMLProviderEditorInput && (editorInput = (XMLProviderEditorInput)this.editor.getEditorInput()).getContextProvider() != null) {
                Object data = attr.getContextData(editorInput.getContextProvider());
                fieldEditor.setFieldData(data);
            }
            Button button = toolkit.createButton(textComp, PluginResources.getString("fieldEditor.lbl"), 8);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ControlAccessor accessor = (ControlAccessor)text.getData(XefDetailsPage.ACCESSOR);
                    String newExpr = fieldEditor.getNewValue(accessor.getValue());
                    if (newExpr != null) {
                        accessor.setValue(newExpr);
                        text.notifyListeners(24, new Event());
                    }
                }
            });
        }
        toolkit.paintBordersFor(textComp);
        return text;
    }

    public void setFocus(Object target) {
        for (Map.Entry<Control, Object> entry : this.values.entrySet()) {
            if (!entry.getValue().equals(target)) continue;
            final Control control = entry.getKey();
            Runnable setFocus = new Runnable(){

                public void run() {
                    control.setFocus();
                }
            };
            if (interactive) {
                this.editor.getSite().getShell().getDisplay().asyncExec(setFocus);
            } else {
                setFocus.run();
            }
            return;
        }
    }

    private String normalizeTooltipText(AnnotatedElement ann) {
        String def;
        if (ann == null) {
            return null;
        }
        String doc = ann.getDocShort();
        if (doc == null) {
            doc = ann.getDocumentation();
        }
        if (doc != null) {
            Matcher m = WHITESPACE_PATTERN.matcher(doc);
            doc = m.replaceAll(" ");
        }
        if (ann instanceof SchemaAttribute && (def = ((SchemaAttribute)ann).getDefault()) != null) {
            doc = doc == null ? "" : String.valueOf(doc) + System.getProperty("line.separator");
            doc = String.valueOf(doc) + "(default: " + def + ")";
        }
        return doc;
    }

    public boolean validate() {
        for (Map.Entry<Control, Object> entry : this.values.entrySet()) {
            ControlAccessor acc = (ControlAccessor)entry.getKey().getData(ACCESSOR);
            if (acc instanceof PasswordControlAccessor && !this.validatePasswordField(entry.getKey())) {
                return false;
            }
            if (!this.element.getTemplate().isSequenceOfAny() || this.validateSequenceOfAny(entry, acc)) continue;
            return false;
        }
        return true;
    }

    private boolean validateSequenceOfAny(Map.Entry<Control, Object> entry, ControlAccessor acc) {
        String s;
        if (entry.getValue() == this.element.getTemplate() && (s = acc.getValue()) != null && s.length() > 0) {
            String elName = this.element.getTemplate().getName();
            s = "<" + elName + ">" + s + "</" + elName + ">";
            SAXBuilder builder = new SAXBuilder();
            try {
                builder.build((InputStream)new ByteArrayInputStream(s.getBytes()));
            }
            catch (Exception e) {
                if (interactive) {
                    MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)"XML content incorrect", (String)("The XML content of the field is not well-formed.\n\n\tMessage: " + e.getMessage()));
                }
                return false;
            }
        }
        return true;
    }

    private boolean validatePasswordField(Control ctrl) {
        PasswordControlAccessor acc = null;
        if (ctrl.getData(ACCESSOR) instanceof PasswordControlAccessor) {
            acc = (PasswordControlAccessor)ctrl.getData(ACCESSOR);
        }
        if (acc == null) {
            return false;
        }
        final Text pwt1 = acc.getPrimaryText();
        Text pwt2 = acc.getSecondaryText();
        if (pwt1.getText().equals(pwt2.getText())) {
            return true;
        }
        if (interactive) {
            MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)"Passwords not the same", (String)"The two password values are not identical, please re-enter the passwords.");
        }
        pwt2.setText("");
        pwt1.setFocus();
        pwt1.setText("");
        this.editor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                pwt1.setFocus();
            }
        });
        return false;
    }

    private void addContextListener(Control control, String xpath) {
        String attribName = this.element.getDependencyName(xpath);
        for (Control masterControl : this.values.keySet()) {
            Object object = this.values.get(masterControl);
            if (!(object instanceof SchemaAttribute) || !((SchemaAttribute)object).getName().equals(attribName)) continue;
            final Control dependentControl = control;
            masterControl.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ControlAccessor accessor = (ControlAccessor)event.widget.getData(XefDetailsPage.ACCESSOR);
                    String filter = accessor.getValue();
                    if (accessor instanceof QNameControlAccessor) {
                        filter = ((QNameControlAccessor)accessor).convertToFullName(filter);
                    }
                    XefDetailsPage.this.updateValues(dependentControl, filter);
                }
            });
        }
    }

    private void updateQNameNamespaceDecl(Control control) {
        if (!(control instanceof Combo) || !(control.getData(ACCESSOR) instanceof QNameControlAccessor)) {
            return;
        }
        Combo combo = (Combo)control;
        String prevItem = (String)control.getData(PREV_VALUE);
        if (prevItem != null && prevItem.length() != 0) {
            boolean inUse = false;
            String prefix = QNameHelper.getPrefixFromQName(prevItem);
            for (Attribute attribute : this.element.getJDOMElement().getAttributes()) {
                if (!QNameHelper.getPrefixFromQName(attribute.getValue()).equals(prefix)) continue;
                inUse = true;
            }
            if (!inUse) {
                this.element.removeNamespaceDeclaration(QNameHelper.getPrefixFromQName(prevItem), QNameHelper.getNamespaceFromQName((Map)control.getData(NS_MAPPINGS), prevItem));
            }
        }
        String selItem = combo.getText();
        this.element.addNamespaceDeclaration(QNameHelper.getPrefixFromQName(selItem), QNameHelper.getNamespaceFromQName((Map)control.getData(NS_MAPPINGS), selItem));
    }

    private class HelpViewSynchingFocusListener
    extends FocusAdapter
    implements FocusListener {
        private final AnnotatedElement item;

        private HelpViewSynchingFocusListener(AnnotatedElement ae) {
            this.item = ae;
        }

        public void focusGained(FocusEvent e) {
            IWorkbenchPage page = XefDetailsPage.this.editor.getSite().getWorkbenchWindow().getActivePage();
            IViewPart v = page.findView("org.eclipse.stp.ui.xef.help.XefHelpView");
            if (v instanceof XefHelpView) {
                XefHelpView view = (XefHelpView)v;
                if (this.item.getDocumentation() != null && !this.item.getDocumentation().equals("")) {
                    view.setHTMLText("<font size=\"+1\"><b>" + this.item.getDisplayName() + "</b></font> <font size=\"-1\">(" + XefEditMasterDetailsBlock.getLabel(XefDetailsPage.this.element) + ")</font><p/>", this.item.getDocumentation());
                } else {
                    ((XefDetailsPage)XefDetailsPage.this).editor.policyEditPage.block.setHelpText(XefDetailsPage.this.element);
                }
            }
        }
    }
}

