/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IShadowProvider;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaProviderFilterWrapper
implements ISchemaProvider {
    private Set<String> allowedSchemas = null;
    private Set<String> allowedSnippets = null;
    private HashMap<String, DisallowedInfo> disallowedSchemas = null;
    private HashMap<String, DisallowedInfo> disallowedSnippets = null;
    private final ISchemaProvider delegate;
    private final List<String> alreadyApplied;
    private final IShadowProvider shadowProvider;

    public SchemaProviderFilterWrapper(ISchemaProvider schemaProvider, List<XMLInstanceElement> filteredElements) {
        this.delegate = schemaProvider;
        this.alreadyApplied = new ArrayList<String>(filteredElements.size());
        for (XMLInstanceElement el : filteredElements) {
            this.alreadyApplied.add(el.getJDOMElement().getNamespaceURI());
        }
        this.shadowProvider = new ShadowProvider();
    }

    public IShadowProvider getShadowProvider() {
        return this.shadowProvider;
    }

    @Override
    public String getSchema(String namespace) {
        this.initializeSchemas();
        if (!this.allowedSchemas.contains(namespace)) {
            return null;
        }
        return this.delegate.getSchema(namespace);
    }

    @Override
    public String getSnippet(String name) {
        this.initializeSnippets();
        if (this.allowedSnippets.contains(name)) {
            return this.delegate.getSnippet(name);
        }
        return null;
    }

    @Override
    public Collection<String> listSchemaNamespaces(String filter) {
        this.initializeSchemas();
        return this.allowedSchemas;
    }

    @Override
    public Collection<String> listSnippets(String filter) {
        this.initializeSnippets();
        return this.allowedSnippets;
    }

    private synchronized void initializeSchemas() {
        if (this.allowedSchemas != null) {
            return;
        }
        this.allowedSchemas = new HashSet<String>();
        this.disallowedSchemas = new HashMap();
        SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
        HashMap<String, ArrayList<String>> disallowedQualifiers = new HashMap<String, ArrayList<String>>();
        ArrayList<String> l = new ArrayList<String>(this.delegate.listSchemaNamespaces(null));
        for (String appl : this.alreadyApplied) {
            l.remove(appl);
            this.disallowedSchemas.put(appl, DisallowedInfo.alreadyApplied(new String[]{appl}));
            for (SchemaElement el : sr.getEntryElements(appl, true, true, this.delegate)) {
                for (Map.Entry entry : el.getQualifiers().entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) continue;
                    ArrayList<String> reasons = (ArrayList<String>)disallowedQualifiers.get(entry.getKey());
                    if (reasons == null) {
                        reasons = new ArrayList<String>();
                        disallowedQualifiers.put((String)entry.getKey(), reasons);
                    }
                    reasons.add(appl);
                }
            }
        }
        Iterator it = l.iterator();
        block3: while (it.hasNext()) {
            String s = (String)it.next();
            for (SchemaElement el : sr.getEntryElements(s, true, true, this.delegate)) {
                DisallowedInfo disallowedInfo;
                for (String string : el.getQualifiers().keySet()) {
                    if (!disallowedQualifiers.containsKey(string)) continue;
                    it.remove();
                    this.disallowedSchemas.put(s, DisallowedInfo.alreadyApplied((Collection)disallowedQualifiers.get(string)));
                    continue block3;
                }
                if (el.getRequires().size() == 0 || (disallowedInfo = SchemaProviderFilterWrapper.requirementsSatisfied(el, this.alreadyApplied)) == null) continue;
                it.remove();
                this.disallowedSchemas.put(s, disallowedInfo);
                continue block3;
            }
        }
        this.allowedSchemas.addAll(l);
    }

    private static DisallowedInfo requirementsSatisfied(SchemaElement el, Collection<String> applied) {
        List<List<String>> requirements = el.getRequires();
        if (requirements.size() == 0) {
            return null;
        }
        for (List<String> required : requirements) {
            if (!SchemaProviderFilterWrapper.requirementSatisfied(required, applied)) continue;
            return null;
        }
        Collection<String> causedBy = SchemaProviderFilterWrapper.flatten(requirements);
        causedBy.removeAll(applied);
        return DisallowedInfo.required(causedBy);
    }

    private static boolean requirementSatisfied(List<String> required, Collection<String> applied) {
        for (String r : required) {
            QName qn = QName.valueOf(r);
            if (applied.contains(qn.getNamespaceURI())) continue;
            return false;
        }
        return true;
    }

    private static Collection<String> flatten(List<List<String>> requires) {
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> l : requires) {
            for (String s : l) {
                QName qn = QName.valueOf(s);
                result.add(qn.getNamespaceURI());
            }
        }
        return result;
    }

    private synchronized void initializeSnippets() {
        if (this.allowedSnippets != null) {
            return;
        }
        this.initializeSchemas();
        this.allowedSnippets = new HashSet<String>();
        this.disallowedSnippets = new HashMap();
        SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
        SAXBuilder builder = new SAXBuilder();
        for (String name : this.delegate.listSnippets(null)) {
            String snippet = this.delegate.getSnippet(name);
            String xml = "<root>" + snippet + "</root>";
            try {
                ArrayList<DisallowedInfo> disallowReasons = new ArrayList<DisallowedInfo>();
                Document doc = builder.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
                for (Object child : doc.getRootElement().getChildren()) {
                    Element el;
                    String ns;
                    if (!(child instanceof Element) || !this.disallowedSchemas.containsKey(ns = (el = (Element)child).getNamespaceURI())) continue;
                    DisallowedInfo info = this.disallowedSchemas.get(ns);
                    if (info.reason == DisallowanceReason.ALREADY_APPLIED) {
                        disallowReasons.add(info);
                        continue;
                    }
                    List<String> allNS = SchemaProviderFilterWrapper.getNamespaces(doc.getRootElement().getChildren());
                    allNS.remove(ns);
                    allNS.addAll(this.alreadyApplied);
                    SchemaElement se = sr.getSchemaElement(ns, el.getName(), true, this.delegate);
                    DisallowedInfo newInfo = SchemaProviderFilterWrapper.requirementsSatisfied(se, allNS);
                    if (newInfo == null) continue;
                    disallowReasons.add(newInfo);
                }
                if (disallowReasons.size() == 0) {
                    this.allowedSnippets.add(name);
                    continue;
                }
                this.disallowedSnippets.put(name, this.formatReasons(disallowReasons));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DisallowedInfo formatReasons(List<DisallowedInfo> disallowReasons) {
        boolean containsAlreadyApplied = false;
        for (DisallowedInfo i : disallowReasons) {
            if (i.reason != DisallowanceReason.ALREADY_APPLIED) continue;
            containsAlreadyApplied = true;
            break;
        }
        if (containsAlreadyApplied) {
            Iterator<DisallowedInfo> it = disallowReasons.iterator();
            while (it.hasNext()) {
                DisallowedInfo i = it.next();
                if (i.reason != DisallowanceReason.REQUIRES) continue;
                it.remove();
            }
        }
        DisallowedInfo info = new DisallowedInfo();
        for (DisallowedInfo i : disallowReasons) {
            info.causes.addAll(i.causes);
            info.reason = i.reason;
        }
        return info;
    }

    private static List<String> getNamespaces(List children) {
        ArrayList<String> l = new ArrayList<String>();
        for (Object o : children) {
            if (!(o instanceof Element)) continue;
            l.add(((Element)o).getNamespaceURI());
        }
        return l;
    }

    @Override
    public synchronized void refresh() {
        this.delegate.refresh();
        this.allowedSnippets = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DisallowanceReason {
        ALREADY_APPLIED{

            public String toString() {
                return "already applied";
            }
        }
        ,
        REQUIRES{

            public String toString() {
                return "required";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisallowedInfo {
        final Collection<String> causes = new TreeSet<String>();
        DisallowanceReason reason;

        private DisallowedInfo() {
        }

        private static DisallowedInfo alreadyApplied(String ... appl) {
            return DisallowedInfo.alreadyApplied((Collection<String>)Arrays.asList(appl));
        }

        private static DisallowedInfo alreadyApplied(Collection<String> appl) {
            DisallowedInfo info = new DisallowedInfo();
            info.causes.addAll(appl);
            info.reason = DisallowanceReason.ALREADY_APPLIED;
            return info;
        }

        public static DisallowedInfo required(Collection<String> req) {
            DisallowedInfo info = new DisallowedInfo();
            info.causes.addAll(req);
            info.reason = DisallowanceReason.REQUIRES;
            return info;
        }
    }

    private class ShadowProvider
    implements IShadowProvider {
        Map<String, List<Object>> shadowed = new HashMap<String, List<Object>>();
        Map<Object, String> reasons = new HashMap<Object, String>();
        boolean initialized = false;
        boolean snippetsInitialized = false;

        private ShadowProvider() {
        }

        private synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            SchemaProviderFilterWrapper.this.initializeSchemas();
            SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
            for (String filter : SchemaProviderFilterWrapper.this.disallowedSchemas.keySet()) {
                try {
                    List<SchemaElement> elements = sr.getEntryElements(filter, true, true, SchemaProviderFilterWrapper.this.delegate);
                    for (SchemaElement el : elements) {
                        List<Object> l;
                        String cat = el.getCategory();
                        if (cat == null) {
                            cat = "Uncategorized";
                        }
                        if ((l = this.shadowed.get(cat)) == null) {
                            l = new ArrayList<Object>();
                            this.shadowed.put(cat, l);
                        }
                        l.add(el);
                        DisallowedInfo info = (DisallowedInfo)SchemaProviderFilterWrapper.this.disallowedSchemas.get(filter);
                        this.reasons.put(el, this.formatDisallowedInfo(el.getNameSpace(), info));
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.stp.xef", 0, "Problem handling schema", (Throwable)e);
                    XefPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            this.initialized = true;
        }

        private synchronized void initializeSnippetCategory() {
            if (this.snippetsInitialized) {
                return;
            }
            SchemaProviderFilterWrapper.this.initializeSnippets();
            List<Object> l = this.shadowed.get("Composite Policies");
            if (l == null) {
                l = new ArrayList<Object>();
                this.shadowed.put("Composite Policies", l);
            }
            for (Map.Entry disallowed : SchemaProviderFilterWrapper.this.disallowedSnippets.entrySet()) {
                l.add(disallowed.getKey());
                this.reasons.put(disallowed.getKey(), this.formatDisallowedInfo((String)disallowed.getKey(), (DisallowedInfo)disallowed.getValue()));
            }
            this.snippetsInitialized = true;
        }

        private String formatDisallowedInfo(String context, DisallowedInfo info) {
            int idx;
            if (info.causes.size() == 1 && info.reason == DisallowanceReason.ALREADY_APPLIED && info.causes.iterator().next().equals(context)) {
                return info.reason.toString();
            }
            String sep = ", ";
            SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
            StringBuilder sb = new StringBuilder();
            for (String uri : info.causes) {
                try {
                    for (SchemaElement se : sr.getEntryElements(uri, true, true, SchemaProviderFilterWrapper.this.delegate)) {
                        if (se == null) continue;
                        sb.append(se.getDisplayName());
                        sb.append(sep);
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.stp.xef", 0, "Problem handling schema", (Throwable)e);
                    XefPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
                sb.append(' ');
            }
            if (info.reason == DisallowanceReason.REQUIRES && (idx = sb.lastIndexOf(sep)) != -1) {
                sb.replace(idx, idx + sep.length(), " and/or ");
            }
            return String.valueOf(sb.toString()) + info.reason.toString();
        }

        public String getReason(Object shadowed) {
            this.initialize();
            return this.reasons.get(shadowed);
        }

        public String[] getShadowCategories() {
            this.initialize();
            Set<String> s = this.shadowed.keySet();
            return s.toArray(new String[s.size()]);
        }

        public Object[] getShadowed(String category) {
            if ("Composite Policies".equals(category)) {
                this.initializeSnippetCategory();
            } else {
                this.initialize();
            }
            List<Object> l = this.shadowed.get(category);
            if (l != null) {
                return l.toArray(new Object[l.size()]);
            }
            return null;
        }
    }
}

