/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.XMLUtil;

public class XPathXMLProvider
implements IXMLProvider {
    private final IFile file;
    private final String xpath;
    private final String rootQName;

    public XPathXMLProvider(IFile f, String xp, String root) {
        this.file = f;
        this.xpath = xp;
        this.rootQName = root;
    }

    public String getRootElementQName() {
        return this.rootQName;
    }

    public String getXML() {
        try {
            return XMLUtil.getXMLSnippet(this.file.getLocation().toFile(), this.xpath, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setXML(String newXML) {
        try {
            XMLUtil.putXMLSnippet(newXML, this.file.getLocation().toFile(), this.xpath);
            this.file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

