/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.stp.xef.ISchemaProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSchemaProvider
implements ISchemaProvider {
    private final ISchemaProvider delegate;
    private final List<String> filters;
    private final List<String> snippetFilters;
    private List<String> allowedSchemas;
    private List<String> allowedSnippets;

    public static FilterSchemaProvider createSchemaFilter(ISchemaProvider delegate, String ... filters) {
        return new FilterSchemaProvider(delegate, Arrays.asList(filters), Arrays.asList(new String[0]));
    }

    public static FilterSchemaProvider createSnippetFilter(ISchemaProvider delegate, String ... filters) {
        return new FilterSchemaProvider(delegate, Arrays.asList(new String[0]), Arrays.asList(filters));
    }

    private FilterSchemaProvider(ISchemaProvider d, List<String> f, List<String> sf) {
        this.delegate = d;
        this.filters = f;
        this.snippetFilters = sf;
    }

    private synchronized void initializeSchemas() {
        if (this.allowedSchemas != null) {
            return;
        }
        this.allowedSchemas = new ArrayList<String>(this.delegate.listSchemaNamespaces(null));
        this.allowedSchemas.removeAll(this.filters);
    }

    private synchronized void initializeSnippets() {
        if (this.allowedSnippets != null) {
            return;
        }
        this.allowedSnippets = new ArrayList<String>(this.delegate.listSnippets(null));
        this.allowedSnippets.removeAll(this.snippetFilters);
    }

    @Override
    public String getSchema(String namespace) {
        this.initializeSchemas();
        if (this.allowedSchemas.contains(namespace)) {
            return this.delegate.getSchema(namespace);
        }
        return null;
    }

    @Override
    public String getSnippet(String name) {
        this.initializeSnippets();
        if (this.allowedSnippets.contains(name)) {
            return this.delegate.getSnippet(name);
        }
        return null;
    }

    @Override
    public Collection<String> listSchemaNamespaces(String filter) {
        this.initializeSchemas();
        return this.allowedSchemas;
    }

    @Override
    public Collection<String> listSnippets(String filter) {
        this.initializeSnippets();
        return this.allowedSnippets;
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }
}

