/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import org.eclipse.stp.ui.xef.editor.ControlAccessor;
import org.eclipse.stp.ui.xef.editor.TextFilter;
import org.eclipse.swt.widgets.Text;

public class PasswordControlAccessor
implements ControlAccessor {
    private final TextFilter textFilter;
    private final Text primaryText;
    private Text secondaryText;
    private String filteredValue;

    PasswordControlAccessor(Text t, TextFilter filter) {
        if (filter == null) {
            throw new NullPointerException("Password Control has incorrectly configured password filter.");
        }
        this.textFilter = filter;
        this.primaryText = t;
    }

    Text getPrimaryText() {
        return this.primaryText;
    }

    Text getSecondaryText() {
        return this.secondaryText;
    }

    public void setSecondaryText(Text t) {
        this.secondaryText = t;
    }

    public String getValue() {
        if (!this.primaryText.getText().equals(this.filteredValue)) {
            this.filteredValue = this.textFilter.filter(this.primaryText.getText());
            if (!this.primaryText.isFocusControl()) {
                this.primaryText.setText(this.filteredValue);
                this.secondaryText.setText(this.filteredValue);
            }
        }
        return this.filteredValue;
    }

    public void setValue(String value) {
        this.filteredValue = value;
        this.primaryText.setText(value);
        if (this.secondaryText != null) {
            this.secondaryText.setText(value);
        }
    }
}

