/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.stp.ui.xef.schema.IContextProvider;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.util.InputStreamHelper;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;

public class XMLProviderEditorInput
extends FileEditorInput {
    private static volatile int counter = 0;
    private final String title;
    private final IXMLProvider provider;
    private final ISchemaProvider schemaProvider;
    private final IContextProvider contextProvider;

    public XMLProviderEditorInput(String t, IProject prj, IXMLProvider p, ISchemaProvider sp, IContextProvider cp) throws IOException, CoreException {
        super(XMLProviderEditorInput.createTempFile(prj, p));
        this.title = t;
        this.provider = p;
        this.schemaProvider = sp;
        this.contextProvider = cp;
    }

    private static IFile createTempFile(IProject project, IXMLProvider provider) throws IOException, CoreException {
        IFile tempfile = project.getFile(".xml.tmp" + System.currentTimeMillis() + "_" + counter++);
        tempfile.getLocation().toFile().deleteOnExit();
        tempfile.create((InputStream)new ByteArrayInputStream(provider.getXML().getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        return tempfile;
    }

    public IContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public ISchemaProvider getSchemaProvider() {
        return this.schemaProvider;
    }

    public IXMLProvider getXMLProvider() {
        return this.provider;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void propagate() throws IOException, CoreException {
        InputStream is = this.getFile().getContents();
        try {
            this.provider.setXML(new String(InputStreamHelper.drain(is)));
            this.getFile().refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            is.close();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof XMLProviderEditorInput) {
            XMLProviderEditorInput otherInput = (XMLProviderEditorInput)((Object)other);
            return this.getXMLProvider().equals(otherInput.getXMLProvider());
        }
        return false;
    }
}

