/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.TextEditorHelper;
import org.eclipse.text.edits.MalformedTreeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScJDTAnnUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJDTAnnUtils.class);

    public static void addAnnotationImport(CompilationUnit compilationUnitAstNode, Annotation annotationNode, ASTRewrite rewrite) {
        String fullAnno = ScAnnotationSupportUtils.getAnnotationImport(annotationNode);
        ArrayList<String> imports = new ArrayList<String>();
        if (fullAnno != null) {
            JDTUtils.addImport(compilationUnitAstNode, fullAnno, rewrite);
            if (!(annotationNode instanceof NormalAnnotation)) {
                return;
            }
            imports.add(fullAnno);
            Class annoCls = ScAnnotationSupportUtils.getAnnotationClass(annotationNode);
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotationNode;
            List pairs = normalAnnotation.values();
            for (MemberValuePair pair : pairs) {
                String name = pair.getName().getIdentifier();
                try {
                    Method method = annoCls.getDeclaredMethod(name, null);
                    Class<?> clsReturnType = method.getReturnType();
                    if (clsReturnType.isPrimitive() || clsReturnType.getPackage().getName().startsWith("java.lang")) continue;
                    String fullQName = clsReturnType.getCanonicalName();
                    if (clsReturnType.isMemberClass()) {
                        fullQName = clsReturnType.getEnclosingClass().getCanonicalName();
                    }
                    if (!imports.contains(fullQName)) {
                        JDTUtils.addImport(compilationUnitAstNode, fullQName, rewrite);
                    }
                    imports.add(fullQName);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addAnnotationOnField(CompilationUnit compilationUnitAstNode, Annotation annotationNode, IField field, ASTRewrite rewrite) {
        ScJDTAnnUtils.addAnnotationImport(compilationUnitAstNode, annotationNode, rewrite);
        Annotation oldAnnotationNode = JDTUtils.findAnnotation(compilationUnitAstNode, (IMember)field, annotationNode);
        if (oldAnnotationNode != null) {
            rewrite.remove((ASTNode)oldAnnotationNode, null);
        }
        IType type = field.getDeclaringType();
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            if (!t.getName().getIdentifier().equals(type.getElementName())) continue;
            String fieldName = field.getElementName();
            FieldDeclaration[] fields = t.getFields();
            int inx = 0;
            while (inx < fields.length) {
                for (Object obj : fields[inx].fragments()) {
                    VariableDeclarationFragment var = (VariableDeclarationFragment)obj;
                    if (!var.getName().getFullyQualifiedName().equals(fieldName)) continue;
                    ListRewrite lrw2 = rewrite.getListRewrite((ASTNode)fields[inx], FieldDeclaration.MODIFIERS2_PROPERTY);
                    lrw2.insertFirst((ASTNode)annotationNode, null);
                }
                ++inx;
            }
        }
    }

    public static void addAnnotationOnMethod(CompilationUnit compilationUnitAstNode, Annotation annotationNode, IMethod method, ASTRewrite rewrite, boolean overwrite) {
        ScJDTAnnUtils.addAnnotationImport(compilationUnitAstNode, annotationNode, rewrite);
        Annotation oldAnnotationNode = JDTUtils.findAnnotation(compilationUnitAstNode, (IMember)method, annotationNode);
        if (oldAnnotationNode != null && overwrite) {
            LOG.debug((Object)"existing annotation found");
            if (!overwrite) {
                return;
            }
            LOG.debug((Object)"overwriting...");
            rewrite.remove((ASTNode)oldAnnotationNode, null);
        }
        IType type = method.getDeclaringType();
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            if (!t.getName().getIdentifier().equals(type.getElementName())) continue;
            String methodName = method.getElementName();
            MethodDeclaration[] meths = t.getMethods();
            int inx = 0;
            while (inx < meths.length) {
                if (meths[inx].getName().getIdentifier().equals(methodName)) {
                    ListRewrite lrw2 = rewrite.getListRewrite((ASTNode)meths[inx], MethodDeclaration.MODIFIERS2_PROPERTY);
                    lrw2.insertFirst((ASTNode)annotationNode, null);
                }
                ++inx;
            }
        }
    }

    public static void addAnnotationOnMethodParam(CompilationUnit compilationUnitAstNode, Annotation annotationNode, SingleVariableDeclaration methodParamDecl, ASTRewrite rewrite, boolean overwrite) {
        ScJDTAnnUtils.addAnnotationImport(compilationUnitAstNode, annotationNode, rewrite);
        Iterator<Annotation> oldAnnotationNodesIter = JDTUtils.getAnnotationsFromParamDecl(methodParamDecl).iterator();
        String annotName = JDTUtils.getBasicAnnotName(annotationNode);
        while (oldAnnotationNodesIter.hasNext()) {
            Annotation oldAnnotationNode = oldAnnotationNodesIter.next();
            if (!annotName.equals(JDTUtils.getBasicAnnotName(oldAnnotationNode))) continue;
            LOG.debug((Object)"existing annotation found");
            if (!overwrite) {
                return;
            }
            LOG.debug((Object)"overwriting...");
            rewrite.remove((ASTNode)oldAnnotationNode, null);
        }
        ListRewrite lrw2 = rewrite.getListRewrite((ASTNode)methodParamDecl, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
        lrw2.insertAt((ASTNode)annotationNode, -1, null);
    }

    public static void addAnnotationOnType(CompilationUnit compilationUnitAstNode, Annotation annotationNode, IType type, ASTRewrite rewrite, boolean overwrite) {
        ScJDTAnnUtils.addAnnotationImport(compilationUnitAstNode, annotationNode, rewrite);
        Annotation oldAnnotationNode = JDTUtils.findAnnotation(compilationUnitAstNode, (IMember)type, annotationNode);
        if (oldAnnotationNode != null && overwrite) {
            LOG.debug((Object)"existing annotation found");
            if (!overwrite) {
                return;
            }
            LOG.debug((Object)"overwriting...");
            rewrite.remove((ASTNode)oldAnnotationNode, null);
        }
        for (TypeDeclaration t : compilationUnitAstNode.types()) {
            if (!t.getName().getIdentifier().equals(type.getElementName())) continue;
            ListRewrite lrw2 = rewrite.getListRewrite((ASTNode)t, TypeDeclaration.MODIFIERS2_PROPERTY);
            lrw2.insertFirst((ASTNode)annotationNode, null);
        }
    }

    public static void addAnnotationsToCu(ICompilationUnit compilationUnitMember, CompilationUnit compilationUnitAstNode, List<Annotation> annotationNodes, IMember member, SingleVariableDeclaration methodParam, boolean save) throws JavaModelException, MalformedTreeException, BadLocationException {
        String source = compilationUnitMember.getBuffer().getContents();
        new Document(source);
        ASTRewrite rewrite = ASTRewrite.create((AST)compilationUnitAstNode.getAST());
        for (Annotation currentAnnotationNode : annotationNodes) {
            if (member instanceof IField) {
                ScJDTAnnUtils.addAnnotationOnField(compilationUnitAstNode, currentAnnotationNode, (IField)member, rewrite);
                continue;
            }
            if (methodParam != null) {
                ScJDTAnnUtils.addAnnotationOnMethodParam(compilationUnitAstNode, currentAnnotationNode, methodParam, rewrite, true);
                continue;
            }
            if (member instanceof IMethod && methodParam == null) {
                ScJDTAnnUtils.addAnnotationOnMethod(compilationUnitAstNode, currentAnnotationNode, (IMethod)member, rewrite, true);
                continue;
            }
            if (!(member instanceof IType)) continue;
            ScJDTAnnUtils.addAnnotationOnType(compilationUnitAstNode, currentAnnotationNode, (IType)member, rewrite, true);
        }
        TextEditorHelper.applyRewrite(compilationUnitMember, rewrite, save);
    }

    public static void addAnnotationToCu(ICompilationUnit compilationUnitMember, CompilationUnit compilationUnitAstNode, Annotation annotationNode, IMember member, SingleVariableDeclaration methodParam, boolean save) throws JavaModelException, MalformedTreeException, BadLocationException {
        ArrayList<Annotation> annotationNodes = new ArrayList<Annotation>(1);
        annotationNodes.add(annotationNode);
        ScJDTAnnUtils.addAnnotationsToCu(compilationUnitMember, compilationUnitAstNode, annotationNodes, member, methodParam, save);
    }

    public static void addAnnotationToCu(ICompilationUnit compilationUnitMember, CompilationUnit compilationUnitAstNode, Annotation annotationNode, IMember member, SingleVariableDeclaration methodParam) throws JavaModelException, MalformedTreeException, BadLocationException {
        ScJDTAnnUtils.addAnnotationToCu(compilationUnitMember, compilationUnitAstNode, annotationNode, member, methodParam, false);
    }
}

