/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class TextEditorHelper {
    public static void applyRewrite(ICompilationUnit cu, ASTRewrite rewrite) throws MalformedTreeException, JavaModelException, IllegalArgumentException {
        TextEditorHelper.applyRewrite(cu, rewrite, false);
    }

    public static void applyRewrite(ICompilationUnit cu, ASTRewrite rewrite, boolean save) throws MalformedTreeException, JavaModelException, IllegalArgumentException {
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild(rewrite.rewriteAST());
        try {
            TextEditorHelper.applyEdit(cu, (TextEdit)edit, save, null);
        }
        catch (ValidateEditException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException, ValidateEditException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CorextMessages.JavaModelUtil_applyedit_operation, 3);
        try {
            IDocument document = null;
            try {
                try {
                    document = TextEditorHelper.aquireDocument(cu, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (save) {
                        TextEditorHelper.commitDocument(cu, document, edit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        new RewriteSessionEditProcessor(document, edit, 2).performEdits();
                    }
                }
                catch (BadLocationException e) {
                    throw new CoreException(JavaUIStatus.createError((int)4, (Throwable)e));
                }
            }
            finally {
                TextEditorHelper.releaseDocument(cu, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IDocument aquireDocument(ICompilationUnit cu, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (TextEditorHelper.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = cu.getPath();
            bufferManager.connect(path, LocationKind.IFILE, monitor);
            return bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
        }
        monitor.done();
        return new Document(cu.getSource());
    }

    private static void commitDocument(ICompilationUnit cu, IDocument document, TextEdit edit, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        IFile file;
        if (TextEditorHelper.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            IStatus status = Resources.makeCommittable((IResource)file, null);
            if (!status.isOK()) {
                throw new ValidateEditException(status);
            }
            new RewriteSessionEditProcessor(document, edit, 2).performEdits();
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).commit(monitor, true);
            return;
        }
        new RewriteSessionEditProcessor(document, edit, 2).performEdits();
    }

    private static void releaseDocument(ICompilationUnit cu, IDocument document, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (TextEditorHelper.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, monitor);
            return;
        }
        cu.getBuffer().setContents(document.get());
        monitor.done();
    }

    public static boolean isPrimary(ICompilationUnit cu) {
        return cu.getOwner() == null;
    }
}

