/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class EnhancedFormEditor
extends FormEditor
implements ISelectionProvider {
    public static final String DEFAULT_EDITOR_PAGE_KEY = "defaultPageKey";
    public static final int SECTION_SPACING_HORIZ = 15;
    public static final int SECTION_SPACING_VERT = 15;
    public static final int SECTION_MARGIN_WIDTH = 10;
    public static final int SECTION_MARGIN_HEIGHT = 10;
    public static final int CONTROL_SPACING_HORIZ = 5;
    public static final int CONTROL_SPACING_VERT = 5;
    public static final int CONTROL_MARGIN_WIDTH = 2;
    public static final int CONTROL_MARGIN_HEIGHT = 2;
    private ListenerList mSelectionListeners = new ListenerList();
    private ISelection mSelection = StructuredSelection.EMPTY;

    public static final GridLayout newPageGridLayout() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        return layout;
    }

    public static final GridLayout newSectionGridLayout() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        return layout;
    }

    public static final FormLayout newPageFormLayout() {
        FormLayout layout = new FormLayout();
        layout.spacing = 15;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        return layout;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                EnhancedFormEditor.this.addSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return EnhancedFormEditor.this.getSelection();
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                EnhancedFormEditor.this.removeSelectionChangedListener(listener);
            }

            public void setSelection(ISelection selection) {
                EnhancedFormEditor.this.setSelection(selection);
            }

            public void fireSelectionChanged(SelectionChangedEvent event) {
                EnhancedFormEditor.this.fireSelectionChanged(event);
            }
        });
    }

    protected void createPages() {
        super.createPages();
        String pageId = this.loadDefaultPage();
        if (pageId != null) {
            this.setActivePage(pageId);
        }
        this.pages.remove(null);
    }

    protected abstract IPropertySheetPage getPropertySheetPage();

    public IFormPage[] getPages() {
        return this.pages.toArray(new IFormPage[this.pages.size()]);
    }

    protected IEditorPart getEditor(int pageIndex) {
        IEditorPart editor = super.getEditor(pageIndex);
        if (editor == null) {
            for (IFormPage page : this.pages) {
                if (page.getIndex() != pageIndex) continue;
                editor = page;
                break;
            }
        }
        return editor;
    }

    public boolean isDirty() {
        boolean dirty = false;
        IFormPage[] pages = this.getPages();
        int index = 0;
        int count = pages.length;
        while (!dirty && index < count) {
            dirty = pages[index] == null ? false : pages[index].isDirty();
            ++index;
        }
        return dirty || super.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage[] pages = this.getPages();
        int index = 0;
        int count = pages.length;
        while (index < count) {
            pages[index].doSave(monitor);
            ++index;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IContentOutlinePage.class)) {
            return this.getContentOutline();
        }
        if (adapter.isAssignableFrom(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (adapter.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    protected abstract IContentOutlinePage getContentOutline();

    protected void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
        this.updateContentOutline(this.getActivePageInstance());
    }

    protected void updateContentOutline(IFormPage part) {
        this.getContentOutline().setSelection((ISelection)new StructuredSelection((Object)part));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.mSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.mSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        this.fireSelectionChanged(event);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        Object[] listeners = this.mSelectionListeners.getListeners();
        int index = 0;
        int count = listeners.length;
        while (index < count) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[index];
            listener.selectionChanged(event);
            ++index;
        }
    }

    public void dispose() {
        this.storeDefaultPage();
        super.dispose();
    }

    protected abstract String getPropertyStorageQualifier();

    private void storeDefaultPage() {
        IFile file;
        IEditorInput input = this.getEditorInput();
        int pageIndex = this.getCurrentPage();
        IFormPage[] pages = this.getPages();
        String pageId = null;
        if (pageIndex > 0 && pageIndex < pages.length) {
            pageId = pages[pageIndex].getId();
        }
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            try {
                file.setPersistentProperty(new QualifiedName(this.getPropertyStorageQualifier(), DEFAULT_EDITOR_PAGE_KEY), pageId);
            }
            catch (CoreException coreException) {}
        }
    }

    private String loadDefaultPage() {
        String pageId = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                pageId = file.getPersistentProperty(new QualifiedName(this.getPropertyStorageQualifier(), DEFAULT_EDITOR_PAGE_KEY));
            }
            catch (CoreException coreException) {}
        }
        return pageId;
    }
}

