/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.adapters.DeployFileDeployAPIAdapterFactory;
import org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter;
import org.eclipse.wst.server.core.IServer;

public class Utilities
extends org.eclipse.stp.soas.deploy.models.deployfile.util.Utilities {
    private static AdapterFactory sDeployAPIAdapterFactory = new DeployFileDeployAPIAdapterFactory();
    private static List sItemAdapterFactories = null;
    private static ComposedAdapterFactory sItemAdapterFactory = null;

    public static List getItemAdapterFactoriesList() {
        if (sItemAdapterFactories == null) {
            sItemAdapterFactories = new Vector(4);
            sItemAdapterFactories.addAll(org.eclipse.stp.soas.deploy.models.deployfile.util.Utilities.getItemAdapterFactoriesList());
            sItemAdapterFactories.add(sDeployAPIAdapterFactory);
        }
        return sItemAdapterFactories;
    }

    public static ComposedAdapterFactory getItemAdapterFactory() {
        if (sItemAdapterFactory == null) {
            sItemAdapterFactory = new ComposedAdapterFactory((Collection)Utilities.getItemAdapterFactoriesList());
        }
        return sItemAdapterFactory;
    }

    public static IPackage adaptToIPackage(EObject object) {
        IDeployAPIAdapter adapter = Utilities.getDeployAPIAdapter(object);
        IPackage retVal = adapter == null ? null : adapter.asPackage();
        return retVal;
    }

    public static ILogicalPackage adaptToILogicalPackage(EObject object) {
        IDeployAPIAdapter adapter = Utilities.getDeployAPIAdapter(object);
        ILogicalPackage retVal = adapter == null ? null : adapter.asLogicalPackage();
        return retVal;
    }

    public static IConfigurablePackage adaptToIConfigurablePackage(EObject object) {
        IDeployAPIAdapter adapter = Utilities.getDeployAPIAdapter(object);
        IConfigurablePackage retVal = adapter == null ? null : adapter.asConfigurablePackage();
        return retVal;
    }

    public static IPhysicalPackage adaptToIPhysicalPackage(EObject object) {
        IDeployAPIAdapter adapter = Utilities.getDeployAPIAdapter(object);
        IPhysicalPackage retVal = adapter == null ? null : adapter.asPhysicalPackage();
        return retVal;
    }

    public static IDeployTarget adaptToIDeployTarget(EObject object) {
        IDeployAPIAdapter adapter = Utilities.getDeployAPIAdapter(object);
        IDeployTarget retVal = adapter == null ? null : adapter.asDeployTarget();
        return retVal;
    }

    public static IServer adaptToIServer(EObject object) {
        IDeployAPIAdapter adapter = Utilities.getDeployAPIAdapter(object);
        IServer retVal = adapter == null ? null : adapter.asServer();
        return retVal;
    }

    public static IDeployAPIAdapter getDeployAPIAdapter(EObject object) {
        IDeployAPIAdapter retVal = (IDeployAPIAdapter)EcoreUtil.getAdapter((List)object.eAdapters(), IDeployAPIAdapter.class);
        if (retVal == null) {
            EditingDomain ed = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
            retVal = ed == null || !(ed instanceof AdapterFactoryEditingDomain) ? (IDeployAPIAdapter)sDeployAPIAdapterFactory.adapt((Notifier)object, IDeployAPIAdapter.class) : (IDeployAPIAdapter)((AdapterFactoryEditingDomain)ed).getAdapterFactory().adapt((Notifier)object, IDeployAPIAdapter.class);
        }
        return retVal;
    }

    public static void removeFolder(File folder) {
        if (folder != null && folder.isDirectory()) {
            Utilities.deleteFile(folder);
            folder = null;
        }
    }

    private static void deleteFile(File Folder) {
        File[] files = Folder.listFiles();
        if (files != null && files.length > 0) {
            int index = 0;
            int count = files.length;
            while (index < count) {
                Utilities.deleteFile(files[index]);
                ++index;
            }
        }
        Folder.delete();
    }

    public static void createFolder(IFolder folder, boolean force, boolean local) throws CoreException {
        IPath rootPath;
        String[] segments = folder.getFullPath().segments();
        IWorkspaceRoot root = folder.getWorkspace().getRoot();
        IPath projectPath = folder.getProject().getFullPath().makeAbsolute();
        IPath tempPath = rootPath = root.getFullPath().makeRelative();
        int i = 0;
        while (i < segments.length) {
            IFolder tempFolder;
            if (!(tempPath = tempPath.append(segments[i]).makeAbsolute()).equals((Object)projectPath) && !(tempFolder = root.getFolder(tempPath)).exists()) {
                tempFolder.create(force, local, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
    }

    public static void moveFolder(IFolder sourceFolder, IFolder destFolder, String fileExtension, boolean keepCopy) throws CoreException {
        if (!sourceFolder.exists()) {
            return;
        }
        if (!destFolder.exists()) {
            Utilities.createFolder(destFolder, true, true);
        }
        IPath sourcePath = sourceFolder.getFullPath().makeAbsolute();
        IResource[] sourceMembers = sourceFolder.members();
        IWorkspaceRoot root = sourceFolder.getWorkspace().getRoot();
        ArrayList movedFiles = new ArrayList();
        Utilities.getMovedResources(sourceMembers, fileExtension, movedFiles);
        for (IFile file : movedFiles) {
            Utilities.moveFile(root, sourcePath, file, destFolder, keepCopy);
        }
    }

    private static void getMovedResources(IResource[] sourceMembers, String fileExtension, ArrayList movedFiles) throws CoreException {
        int i = 0;
        while (i < sourceMembers.length) {
            IResource resource = sourceMembers[i];
            if (resource instanceof IFile) {
                IFile tempFile = (IFile)resource;
                if (fileExtension != null && fileExtension.equalsIgnoreCase(tempFile.getFileExtension())) {
                    movedFiles.add(tempFile);
                }
            } else if (resource instanceof IFolder) {
                IResource[] members = ((IFolder)resource).members();
                Utilities.getMovedResources(members, fileExtension, movedFiles);
            }
            ++i;
        }
    }

    private static void moveFile(IWorkspaceRoot root, IPath basePath, IFile sourceFile, IFolder destFolder, boolean keepCopy) throws CoreException {
        IFolder tempFolder = destFolder;
        IPath filePath = sourceFile.getFullPath().makeAbsolute();
        int baseSegmentCount = basePath.segmentCount();
        String fileName = sourceFile.getName();
        String[] fileSegments = filePath.segments();
        int i = baseSegmentCount;
        while (i < fileSegments.length - 1) {
            IPath tempFolderPath = tempFolder.getFullPath().append(fileSegments[i]).makeAbsolute();
            if (!(tempFolder = root.getFolder(tempFolderPath)).exists()) {
                Utilities.createFolder(tempFolder, true, true);
            }
            ++i;
        }
        IPath destTempPath = tempFolder.getFullPath().append(fileName).makeAbsolute();
        IFile destTempFile = root.getFile(destTempPath);
        if (destTempFile.exists()) {
            destTempFile.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        sourceFile.copy(destTempPath, true, (IProgressMonitor)new NullProgressMonitor());
        if (!keepCopy) {
            sourceFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            IContainer oldContainer = sourceFile.getParent();
            while (oldContainer.members().length == 0) {
                oldContainer.delete(true, (IProgressMonitor)new NullProgressMonitor());
                oldContainer = oldContainer.getParent();
            }
        }
    }
}

