/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.MatchRule;

public class Version
implements IVersion {
    private int major;
    private int minor;
    private int release;
    private String build;
    public static final Version NULL_VERSION = new Version(0, 0, 0, "");

    public Version(int major, int minor, int release, String build) {
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.build = build;
    }

    public static Version valueOf(String version) {
        int maj = 0;
        int min = 0;
        try {
            if (version.length() > 1 && version.indexOf(".") >= 0) {
                min = Integer.valueOf(version.substring(version.indexOf(".") + 1));
                maj = Integer.valueOf(version.substring(0, version.indexOf(".")));
            } else if (Integer.valueOf(version) != null) {
                return new Version(Integer.valueOf(version), min, 0, "");
            }
        }
        catch (Exception exception) {
            return NULL_VERSION;
        }
        return new Version(maj, min, 0, "");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    public String getBuild() {
        return this.build;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(((Version)o).toString());
    }

    public boolean equals(Object obj) {
        boolean retVal = obj instanceof Version ? this.compareTo(obj) == 0 : false;
        return retVal;
    }

    public boolean isCompatibleWithVersion(IVersion actual, MatchRule matchRule) {
        boolean retVal;
        if (matchRule == MatchRule.PERFECT) {
            retVal = this.comparePerfect(actual);
        } else if (matchRule == MatchRule.EQUIVALENT) {
            retVal = this.compareEquivalent(actual);
        } else if (matchRule == MatchRule.COMPATIBLE) {
            retVal = this.compareCompatible(actual);
        } else if (matchRule == MatchRule.EQUAL_OR_GREATER) {
            retVal = this.compareEqualOrGreater(actual);
        } else {
            throw new IllegalArgumentException();
        }
        return retVal;
    }

    public String toString() {
        if (this.build == null || "".equals(this.build)) {
            return String.valueOf(this.major) + "." + this.minor + "." + this.release;
        }
        return String.valueOf(this.major) + "." + this.minor + "." + this.release + "." + this.build;
    }

    private boolean comparePerfect(IVersion actual) {
        return this.getMajor() == actual.getMajor() && this.getMinor() == actual.getMinor() && this.getRelease() == actual.getRelease() && this.getBuild().compareTo(actual.getBuild()) == 0;
    }

    private boolean compareEquivalent(IVersion actual) {
        boolean retVal = this.getMajor() == actual.getMajor() ? (this.getMinor() == actual.getMinor() ? (this.getRelease() == actual.getRelease() ? this.getBuild().compareTo(actual.getBuild()) <= 0 : this.getRelease() < actual.getRelease()) : false) : false;
        return retVal;
    }

    private boolean compareCompatible(IVersion actual) {
        boolean retVal = this.getMajor() == actual.getMajor() ? (this.getMinor() == actual.getMinor() ? (this.getRelease() == actual.getRelease() ? this.getBuild().compareTo(actual.getBuild()) <= 0 : this.getRelease() < actual.getRelease()) : this.getMinor() < actual.getMinor()) : false;
        return retVal;
    }

    private boolean compareEqualOrGreater(IVersion actual) {
        boolean retVal = this.getMajor() == actual.getMajor() ? (this.getMinor() == actual.getMinor() ? (this.getRelease() == actual.getRelease() ? this.getBuild().compareTo(actual.getBuild()) <= 0 : this.getRelease() < actual.getRelease()) : this.getMinor() < actual.getMinor()) : this.getMajor() < actual.getMajor();
        return retVal;
    }
}

