/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.deploy.models.deployfile.util.Utilities;

public class CreateDeployFileOperation
implements IRunnableWithProgress {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final IFile mFile;
    private final Root mRoot;

    public CreateDeployFileOperation(IFile file, Root root) {
        this.mFile = file;
        this.mRoot = root;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                Utilities.fixServerReferences((Root)this.mRoot);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI fileURI = URI.createPlatformResourceURI((String)this.mFile.getFullPath().toString());
                Resource resource = resourceSet.createResource(fileURI);
                resource.getContents().add((Object)this.mRoot);
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", DEFAULT_ENCODING);
                resource.save(options);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

