/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.ui.actions;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.internal.deploy.ui.CreatePackageControl;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PackageConstructorDialog
extends TitleAreaDialog {
    private ListViewer _packageConstructorList;
    private ILogicalPackage _package;
    private IPackageConstructorExtension _selectedPackageConstructor;

    public PackageConstructorDialog(Shell parentShell, ILogicalPackage pkg) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._package = pkg;
        this._selectedPackageConstructor = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DeployCorePlugin.getDefault().getResourceString("PackageConstructorDialog.shell.text"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        content.setLayout((Layout)gl);
        this._packageConstructorList = new ListViewer(content, 2820);
        GridData partListData = new GridData(1808);
        this._packageConstructorList.getList().setLayoutData((Object)partListData);
        this._packageConstructorList.getList().setFont(parent.getFont());
        this._packageConstructorList.setContentProvider((IContentProvider)new CreatePackageControl.PackageConstructorContentProvider());
        this._packageConstructorList.setLabelProvider((IBaseLabelProvider)new CreatePackageControl.PackageConstructorLabelProvider());
        this._packageConstructorList.addFilter((ViewerFilter)new CreatePackageControl.TechnologyTypeFilter(this._package));
        this._packageConstructorList.setInput((Object)DeploymentExtensionManager.getInstance());
        this._packageConstructorList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button ok = PackageConstructorDialog.this.getButton(0);
                if (ok != null) {
                    if (((IStructuredSelection)PackageConstructorDialog.this._packageConstructorList.getSelection()).size() > 0) {
                        ok.setEnabled(true);
                    } else {
                        ok.setEnabled(false);
                    }
                }
                PackageConstructorDialog.this.updateSelectedPackageConstructorNames();
            }
        });
        this.setTitle(DeployCorePlugin.getDefault().getResourceString("PackageConstructorDialog.title"));
        this.setMessage(DeployCorePlugin.getDefault().getResourceString("PackageConstructorDialog.message"));
        if (this._packageConstructorList.getList().getItemCount() > 0) {
            this._packageConstructorList.setSelection((ISelection)new StructuredSelection(this._packageConstructorList.getElementAt(0)));
        }
        return content;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getButton(0).setEnabled(this._packageConstructorList.getList().getItemCount() > 0);
        return contents;
    }

    public IPackageConstructorExtension getSelectedPackageConstructor() {
        return this._selectedPackageConstructor;
    }

    private void updateSelectedPackageConstructorNames() {
        IStructuredSelection selection = (IStructuredSelection)this._packageConstructorList.getSelection();
        this._selectedPackageConstructor = selection.size() == 0 ? null : (IPackageConstructorExtension)selection.getFirstElement();
    }
}

