/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.editors.EMFFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.editors.ConfigurationPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployFileOutlinePage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.IntroductionPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.OverviewPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DeployEditor
extends EMFFormEditor {
    public static final String ID_INTRODUCTION = "DeployDefinitionEditor.page.introduction";
    public static final String ID_OVERVIEW = "DeployDefinitionEditor.page.overview";
    public static final String ID_CONFIGURATION = "DeployDefinitionEditor.page.configuration";
    public static final String ID_SUMMARY = "DeployDefinitionEditor.page.summary";
    private DeployFileOutlinePage mOutlinePage;

    public void doSave(IProgressMonitor monitor) {
        Utilities.fixServerReferences((Root)((Root)this.getModelRoot()));
        super.doSave(monitor);
    }

    protected AdapterFactory createModelAdapterFactory() {
        return Utilities.getItemAdapterFactory();
    }

    public void dispose() {
        super.dispose();
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        boolean retVal = name.endsWith(".deploy");
        return retVal;
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(DeployCorePlugin.getDefault().getFormColors(display));
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new IntroductionPage(this, ID_INTRODUCTION, DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTAB.Introduction")));
            this.addPage((IFormPage)new OverviewPage(this, ID_OVERVIEW, DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTAB.Overview")));
            this.addPage((IFormPage)new ConfigurationPage(this, ID_CONFIGURATION, DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.PGTAB.Configuration")));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected IContentOutlinePage getContentOutline() {
        if (this.mOutlinePage == null) {
            this.mOutlinePage = new DeployFileOutlinePage(this);
            this.mOutlinePage.setSelection(this.getSelection());
        }
        return this.mOutlinePage;
    }

    protected String getPropertyStorageQualifier() {
        return DeployCorePlugin.getDefault().getBundle().getSymbolicName();
    }
}

