/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.DeployFileNewWizard;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.ISummaryDataSource;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeployFileDescriptionWizardPage
extends WizardPage
implements ISummaryDataSource {
    public static final String LABEL_NAME = DeployCorePlugin.getDefault().getResourceString("LABEL.Name");
    public static final String LABEL_DESCRIPTION = DeployCorePlugin.getDefault().getResourceString("LABEL.Description");
    private static final int DESCRIPTION_CHAR_WIDTH = 60;
    private Text mNameText;
    private Text mDescText;
    private boolean mNameIntialized = false;
    private String mDeployName = new String();
    private String mDeployDescription = new String();

    public DeployFileDescriptionWizardPage(String pageName) {
        super(pageName);
    }

    public DeployFileDescriptionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void init(Root root) {
    }

    public String getDeployDescription() {
        return this.mDeployDescription;
    }

    public void setDeployDescription(String deployDescription) {
        this.mDeployDescription = deployDescription;
    }

    public String getDeployName() {
        return this.mDeployName;
    }

    public void setDeployName(String deployName) {
        this.mDeployName = deployName;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(1808));
        Label label = new Label(content, 0);
        label.setText(LABEL_NAME);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.mNameText = new Text(content, 2048);
        data = new GridData(768);
        this.mNameText.setLayoutData((Object)data);
        this.mNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeployFileDescriptionWizardPage.this.handleNameModify(e);
            }
        });
        label = new Label(content, 0);
        label.setText(LABEL_DESCRIPTION);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.mDescText = new Text(content, 2626);
        GC gc = new GC((Drawable)this.mDescText);
        gc.setFont(this.mDescText.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data = new GridData(1296);
        data.horizontalSpan = 2;
        data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)DESCRIPTION_CHAR_WIDTH);
        this.mDescText.setLayoutData((Object)data);
        this.mDescText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeployFileDescriptionWizardPage.this.handleDescriptionModify(e);
            }
        });
        this.initControls();
        this.setControl((Control)content);
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>(2);
        summaryData.add(new String[]{DeployCorePlugin.getDefault().getResourceString("DeployFileDescriptionWizardPage.summary.name"), this.getDeployName()});
        summaryData.add(new String[]{DeployCorePlugin.getDefault().getResourceString("DeployFileDescriptionWizardPage.summary.description"), this.getDeployDescription()});
        return summaryData;
    }

    private void initControls() {
        this.mNameText.setText(this.mDeployName);
        this.mDescText.setText(this.mDeployDescription);
        this.updateControls();
        this.validate();
    }

    private void handleNameModify(ModifyEvent event) {
        this.mDeployName = this.mNameText.getText();
        this.validate();
    }

    private void handleDescriptionModify(ModifyEvent event) {
        this.mDeployDescription = this.mDescText.getText();
        this.validate();
    }

    private void updateControls() {
    }

    private void validate() {
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        if (visible && !this.mNameIntialized) {
            String fileName = ((DeployFileNewWizard)this.getWizard()).getOutputFile().getProjectRelativePath().lastSegment();
            int extPos = fileName.lastIndexOf(46);
            if (extPos > 0) {
                fileName = fileName.substring(0, extPos);
            }
            this.mNameText.setText(fileName);
            this.mNameIntialized = true;
        }
        super.setVisible(visible);
    }
}

