/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.List;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;

public class MergedSupportedTechnologyType
implements ISupportedTechnologyType {
    private List mSupportedTechnologies;
    private ITechnologyDefinition mTechnologyDef;
    private IVersion mMinVersion;
    private IVersion mMaxVersion;

    public MergedSupportedTechnologyType(ISupportedTechnologyType istt1, ISupportedTechnologyType istt2) {
        if (istt1 == istt2) {
            throw new IllegalArgumentException("istt1 == istt2");
        }
        this.mTechnologyDef = istt1.getTechnologyDefinition();
        this.mMinVersion = istt1.getMinVersion().compareTo(istt2.getMinVersion()) < 0 ? istt1.getMinVersion() : istt2.getMinVersion();
        this.mMaxVersion = istt1.getMaxVersion().compareTo(istt2.getMaxVersion()) > 0 ? istt1.getMaxVersion() : istt2.getMaxVersion();
        if (istt1 instanceof MergedSupportedTechnologyType) {
            this.mSupportedTechnologies.addAll(((MergedSupportedTechnologyType)istt1).getSupportedTechnologies());
        } else {
            this.mSupportedTechnologies.add(istt1);
        }
        if (istt2 instanceof MergedSupportedTechnologyType) {
            this.mSupportedTechnologies.addAll(((MergedSupportedTechnologyType)istt2).getSupportedTechnologies());
        } else {
            this.mSupportedTechnologies.add(istt2);
        }
    }

    public ITechnologyDefinition getTechnologyDefinition() {
        return this.mTechnologyDef;
    }

    public IVersion getMinVersion() {
        return this.mMinVersion;
    }

    public IVersion getMaxVersion() {
        return this.mMaxVersion;
    }

    public boolean supportsTechnology(ITechnologyType type) {
        IVersion typeVersion = type.getVersion();
        boolean retVal = type.getTechnologyDefinition().equals(this.getTechnologyDefinition()) && typeVersion.compareTo(this.getMaxVersion()) <= 0 && typeVersion.compareTo(this.getMinVersion()) >= 0;
        return retVal;
    }

    public List getSupportedTechnologies() {
        return this.mSupportedTechnologies;
    }
}

