/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IServerDefinition;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyMap;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;

public class ServerDefinition
implements IServerDefinition,
Comparable {
    public static final String ATTR_ID = "id";
    private IConfigurationElement mElement;
    private String mID;
    private SortedMap mSupportingServerVersionssByTechnologyDef;
    private SortedMap mTechnologyMapsByServerVersion;

    public ServerDefinition(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
        this.mSupportingServerVersionssByTechnologyDef = new TreeMap();
        this.mTechnologyMapsByServerVersion = new TreeMap(new DecendingVersionOrder());
    }

    public String getID() {
        return this.mID;
    }

    public ITechnologyMap[] getTechnologyMaps() {
        return this.mTechnologyMapsByServerVersion.values().toArray(new ITechnologyMap[0]);
    }

    public ITechnologyMap getTechnologyMap(IVersion serverVersion) {
        ITechnologyMap techMap;
        Iterator it = this.mTechnologyMapsByServerVersion.tailMap(serverVersion).values().iterator();
        if (it.hasNext()) {
            techMap = (ITechnologyMap)it.next();
            if (!techMap.getServerVersion().isCompatibleWithVersion(serverVersion, techMap.getVersionMatchRule())) {
                techMap = null;
            }
        } else {
            techMap = null;
        }
        return techMap;
    }

    public IVersion[] getSupportingServerVersions(ITechnologyDefinition techDef) {
        return this.getSupportingServerVersionsSet(techDef).toArray(new IVersion[0]);
    }

    void addTechnologyMap(ITechnologyMap itm) throws PackageExtensionException {
        Assert.isTrue((boolean)itm.getServerDefinition().equals(this));
        if (this.mTechnologyMapsByServerVersion.containsKey(itm.getServerVersion())) {
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("ServerDefinition.trace.error.duplicateTechnologyMap", new Object[]{this.mID, itm.getServerVersion()}));
                System.err.flush();
            }
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("ServerDefinition.exception.duplicateTechnologyMap"));
        }
        this.mTechnologyMapsByServerVersion.put(itm.getServerVersion(), itm);
        this.addTechnologiesToList(itm);
    }

    private void addTechnologiesToList(ITechnologyMap itm) {
        ISupportedTechnologyType[] techTypes = itm.getSupportedTechnologyTypes();
        int index = 0;
        int count = techTypes.length;
        while (index < count) {
            ITechnologyDefinition techDef = techTypes[index].getTechnologyDefinition();
            SortedSet serverVersions = this.getSupportingServerVersionsSet(techDef);
            serverVersions.add(itm.getServerVersion());
            ++index;
        }
    }

    private SortedSet getSupportingServerVersionsSet(ITechnologyDefinition techDef) {
        TreeSet serverVersions = (TreeSet)this.mSupportingServerVersionssByTechnologyDef.get(techDef);
        if (serverVersions == null) {
            serverVersions = new TreeSet(new DecendingVersionOrder());
            this.mSupportingServerVersionssByTechnologyDef.put(techDef, serverVersions);
        }
        return serverVersions;
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        this.mElement = element;
        this.mID = element.getAttribute(ATTR_ID);
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("ServerDefinition.trace.error.serverDefinitionParseError", new Object[]{this.getID()}));
            System.out.flush();
        }
        if (this.mID == null) {
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("ServerDefinition.exception.idNotSpecified"));
        }
    }

    public int compareTo(Object o) {
        return this.getID().compareTo(((ServerDefinition)o).getID());
    }

    public boolean equals(Object obj) {
        boolean retVal = this == obj ? true : (obj instanceof ServerDefinition ? this.getID().equals(((ServerDefinition)obj).getID()) : false);
        return retVal;
    }

    public int hashCode() {
        return this.mID.hashCode();
    }

    private static class DecendingVersionOrder
    implements Comparator {
        private DecendingVersionOrder() {
        }

        public int compare(Object o1, Object o2) {
            return -((Comparable)o1).compareTo(o2);
        }
    }
}

