/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.wst.server.core.IModule;

public class Tomcat60Handler
implements ITomcatVersionHandler {
    public IStatus verifyInstallPath(IPath installPath) {
        return TomcatPlugin.verifyInstallPathWithFolderCheck(installPath, "org.eclipse.jst.server.tomcat.60");
    }

    public String getRuntimeClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public List getRuntimeClasspath(IPath installPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("bin");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("bootstrap.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return cp;
    }

    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (starting) {
            list.add("start");
        } else {
            list.add("stop");
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    public String[] getExcludedRuntimeProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        return TomcatVersionHelper.getCatalinaVMArguments(installPath, configPath, deployPath, isTestEnv);
    }

    public String getRuntimePolicyFile(IPath configPath) {
        return configPath.append("conf").append("catalina.policy").toOSString();
    }

    public IStatus canAddModule(IModule module) {
        String version = module.getModuleType().getVersion();
        if ("2.2".equals(version) || "2.3".equals(version) || "2.4".equals(version) || "2.5".equals(version)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec60, null);
    }

    public IPath getRuntimeBaseDirectory(TomcatServer server) {
        return TomcatVersionHelper.getStandardBaseDirectory(server);
    }

    public IStatus prepareRuntimeDirectory(IPath baseDir) {
        return TomcatVersionHelper.createCatalinaInstanceDirectory(baseDir);
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        return TomcatVersionHelper.createDeploymentDirectory(deployPath, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_5.xsd\" version=\"2.5\">\n</web-app>");
    }

    public IStatus prepareForServingDirectly(IPath baseDir, TomcatServer server) {
        IStatus status;
        if (server.isServeModulesWithoutPublish()) {
            status = TomcatVersionHelper.copyLoaderJar(this.getRuntimeBaseDirectory(server).append("lib"), server.getServer().getRuntime().getRuntimeType().getId());
            if (status.isOK() && server.isTestEnvironment()) {
                status = TomcatVersionHelper.updatePropertiesToServeDirectly(baseDir, "lib", "common");
            }
        } else {
            TomcatVersionHelper.removeLoaderJar(this.getRuntimeBaseDirectory(server).append("lib"), server.getServer().getRuntime().getRuntimeType().getId());
            status = Status.OK_STATUS;
        }
        return status;
    }

    public String getSharedLoader(IPath baseDir) {
        return "common";
    }

    public boolean supportsServeModulesWithoutPublish() {
        return true;
    }

    public boolean supportsDebugArgument() {
        return false;
    }

    public boolean supportsSeparateContextFiles() {
        return true;
    }
}

