/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.server.tomcat.core.internal.CatalinaPropertiesUtil;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.wst.IModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Loader;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class TomcatPublishModuleVisitor
implements IModuleVisitor {
    protected final IPath baseDir;
    protected final ServerInstance serverInstance;
    protected final String sharedLoader;
    protected final List earCommonResources = new ArrayList();
    protected Set virtualClasspathElements = new LinkedHashSet();

    TomcatPublishModuleVisitor(IPath catalinaBase, ServerInstance serverInstance, String sharedLoader) {
        this.baseDir = catalinaBase;
        this.serverInstance = serverInstance;
        this.sharedLoader = sharedLoader;
    }

    public void visitWebComponent(IVirtualComponent component) throws CoreException {
    }

    public void visitArchiveComponent(IPath runtimePath, IPath workspacePath) {
        this.addVirtualResource(runtimePath, workspacePath);
    }

    public void visitDependentComponent(IPath runtimePath, IPath workspacePath) {
        this.addVirtualResource(runtimePath, workspacePath);
    }

    public void visitWebResource(IPath runtimePath, IPath workspacePath) {
        this.addVirtualResource(runtimePath, workspacePath);
    }

    public void visitEarResource(IPath runtimePath, IPath workspacePath) {
        this.earCommonResources.add(workspacePath.toOSString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endVisitEarComponent(IVirtualComponent component) throws CoreException {
        if (this.earCommonResources.size() <= 0) return;
        try {
            try {
                CatalinaPropertiesUtil.addGlobalClasspath(this.baseDir.append("conf/catalina.properties").toFile(), this.sharedLoader, this.earCommonResources.toArray(new String[this.earCommonResources.size()]));
            }
            catch (IOException e) {
                Trace.trace((byte)1, "Unable to add ear path entries to catalina.properties", e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.earCommonResources.clear();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.earCommonResources.clear();
            return;
        }
    }

    public void visitClasspathEntry(IPath rtFolder, IClasspathEntry entry) {
        if (entry != null) {
            this.addVirtualResource(rtFolder, entry.getPath());
        }
    }

    public void endVisitWebComponent(IVirtualComponent component) throws CoreException {
        String path;
        String docBase;
        Context projectContext;
        boolean dirty = false;
        IModule module = ServerUtil.getModule((IProject)component.getProject());
        Context context = this.findContext(module);
        if (context == null) {
            String name = module != null ? module.getName() : component.getName();
            Trace.trace((byte)2, "Could not find context for module " + name);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishContextNotFound, (Object)name), null));
        }
        String contextName = null;
        boolean reloadable = true;
        contextName = context.getPath();
        reloadable = Boolean.valueOf(context.getReloadable());
        if (contextName.startsWith("/")) {
            contextName = contextName.substring(1);
        }
        if ("".equals(contextName)) {
            contextName = "ROOT";
        }
        if ((projectContext = this.getProjectContextXml(component)) != null) {
            projectContext.copyChildrenTo(context);
            Map attrs = projectContext.getAttributes();
            Iterator iter = attrs.keySet().iterator();
            while (iter.hasNext()) {
                String actualValue;
                String value;
                String name = (String)iter.next();
                if (name.equalsIgnoreCase("path") || name.equalsIgnoreCase("docBase") || name.equalsIgnoreCase("source") || (value = (String)attrs.get(name)).equals(actualValue = context.getAttributeValue(name))) continue;
                context.setAttributeValue(name, value);
                dirty = true;
            }
        }
        if (!(docBase = component.getRootFolder().getUnderlyingFolder().getLocation().toOSString()).equals(context.getDocBase())) {
            dirty = true;
            context.setDocBase(docBase);
        }
        if (reloadable != Boolean.valueOf(context.getReloadable())) {
            dirty = true;
            context.setReloadable(Boolean.toString(reloadable));
        }
        String string = path = contextName.equals("ROOT") ? "" : "/" + contextName;
        if (!path.equals(context.getPath())) {
            dirty = true;
            context.setPath(path);
        }
        context.getResources().setClassName("org.eclipse.jst.server.tomcat.loader.WtpDirContext");
        Loader loader = context.getLoader();
        loader.setClassName("org.eclipse.jst.server.tomcat.loader.WtpWebappLoader");
        loader.setUseSystemClassLoaderAsParent(Boolean.FALSE.toString());
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.virtualClasspathElements.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(";");
        }
        this.virtualClasspathElements.clear();
        String vcp = buffer.toString();
        String oldVcp = loader.getVirtualClasspath();
        if (!vcp.equals(oldVcp)) {
            dirty = true;
            loader.setVirtualClasspath(vcp);
            context.getResources().setVirtualClasspath(vcp);
        }
    }

    private void addVirtualResource(IPath runtimePath, IPath workspacePath) {
        this.virtualClasspathElements.add(workspacePath.toOSString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Context getProjectContextXml(IVirtualComponent component) throws CoreException {
        IVirtualFile contextFile = (IVirtualFile)component.getRootFolder().findMember("META-INF/context.xml");
        Context contextElement = null;
        if (contextFile == null) return contextElement;
        if (!contextFile.exists()) return contextElement;
        Factory factory = new Factory();
        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
        InputStream fis = null;
        try {
            try {
                fis = contextFile.getUnderlyingFile().getContents();
                contextElement = (Context)factory.loadDocument(fis);
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Exception reading " + contextFile, e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return contextElement;
        }
        fis.close();
        return contextElement;
    }

    protected Context findContext(IModule module) {
        if (module == null) {
            return null;
        }
        String source = module.getId();
        Context[] contexts = this.serverInstance.getContexts();
        int i = 0;
        while (i < contexts.length) {
            if (source.equals(contexts[i].getSource())) {
                return contexts[i];
            }
            ++i;
        }
        return null;
    }
}

