/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.javascript.core.internal.contenttype.ContentTypeIdForJavaScript;
import org.eclipse.wst.javascript.ui.internal.actions.MultiPageEditorActionBarContributorJS;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditor;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPluginImageHelper;
import org.eclipse.wst.javascript.ui.internal.editor.JSPreviewPage;
import org.eclipse.wst.javascript.ui.internal.editor.JavaScriptUIMessages;
import org.eclipse.wst.javascript.ui.internal.editor.Logger;

public class JSMultiPageEditorPart
extends MultiPageEditorPart {
    private ActivationListener fActivationListener;
    JSEditor fEditor = null;
    private JSPreviewPage fPreviewPage = null;
    private int fPreviewPageIndex = 1;
    private int fSourcePageIndex = 0;
    private IPropertyListener fSourcePagePropertyListener;
    private Image fTitleImage = null;
    static /* synthetic */ Class class$0;

    private void addPreviewPage() {
        this.fPreviewPageIndex = this.addPage(this.fPreviewPage.getControl());
        this.setPageText(this.fPreviewPageIndex, JavaScriptUIMessages.Preview);
    }

    private void addSourcePage() {
        try {
            this.fEditor = new JSEditor();
            this.fEditor.setEditorPart((IEditorPart)this);
            this.fSourcePagePropertyListener = new SourcePagePropertyListener();
            this.fEditor.addPropertyListener(this.fSourcePagePropertyListener);
            this.fSourcePageIndex = this.addPage((IEditorPart)this.fEditor, this.getEditorInput());
            this.setPageText(this.fSourcePageIndex, JavaScriptUIMessages.Source);
        }
        catch (PartInitException exception) {
            this.dispose();
            throw new RuntimeException(exception);
        }
    }

    protected void createPages() {
        this.addSourcePage();
        try {
            this.fPreviewPage = this.createPreviewPage();
            this.addPreviewPage();
        }
        catch (SWTError e) {
            Logger.logException(e);
        }
        this.fTitleImage = JSEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/javascript_view.gif").createImage();
        this.setTitleImage(this.fTitleImage);
    }

    private JSPreviewPage createPreviewPage() {
        return new JSPreviewPage(this.getContainer(), this.fEditor);
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.fEditor ? new MultiPageEditorSite(this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = JSMultiPageEditorPart.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof MultiPageEditorActionBarContributorJS) {
                    contributor = ((MultiPageEditorActionBarContributorJS)multiContributor).getSourceViewerActionContributor();
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForJavaScript.ContentTypeID_JAVASCRIPT) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    public void dispose() {
        if (this.fSourcePagePropertyListener != null) {
            this.fEditor.removePropertyListener(this.fSourcePagePropertyListener);
            this.fSourcePagePropertyListener = null;
        }
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.fTitleImage != null) {
            this.fTitleImage.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.fEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.fEditor.doSaveAs();
    }

    public Object getAdapter(Class required) {
        Object o = super.getAdapter(required);
        if (o == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.search.ui.text.ISearchEditorAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            o = clazz.equals(required) ? new ISearchEditorAccess(){

                public IDocument getDocument(Match match) {
                    IDocument document = null;
                    if (JSMultiPageEditorPart.this.fEditor != null) {
                        document = JSMultiPageEditorPart.this.fEditor.getDocumentProvider().getDocument((Object)JSMultiPageEditorPart.this.fEditor.getEditorInput());
                    }
                    return document;
                }

                public IAnnotationModel getAnnotationModel(Match match) {
                    IAnnotationModel annoModel = null;
                    if (JSMultiPageEditorPart.this.fEditor != null) {
                        annoModel = JSMultiPageEditorPart.this.fEditor.getDocumentProvider().getAnnotationModel((Object)JSMultiPageEditorPart.this.fEditor.getEditorInput());
                    }
                    return annoModel;
                }
            } : this.fEditor.getAdapter(required);
        }
        return o;
    }

    public String getTitle() {
        if (this.getEditorInput() != null) {
            return this.getEditorInput().getName();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    public boolean isSaveAsAllowed() {
        return this.fEditor.isSaveAsAllowed();
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == this.fPreviewPageIndex) {
            this.fPreviewPage.refresh();
        }
        super.pageChange(newPageIndex);
    }

    private class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void handleActivation() {
            if (this.fIsHandlingActivation) return;
            if (JSMultiPageEditorPart.this.fEditor == null) {
                return;
            }
            if (this.fActivePart != JSMultiPageEditorPart.this) return;
            this.fIsHandlingActivation = true;
            try {
                JSMultiPageEditorPart.this.fEditor.safelySanityCheckState(JSMultiPageEditorPart.this.getEditorInput());
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fIsHandlingActivation = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fIsHandlingActivation = false;
                return;
            }
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == JSMultiPageEditorPart.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ ActivationListener this$1;
                    {
                        this.this$1 = activationListener;
                    }

                    public void run() {
                        this.this$1.handleActivation();
                    }
                });
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class SourcePagePropertyListener
    implements IPropertyListener {
        private SourcePagePropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 258: {
                    if (source != JSMultiPageEditorPart.this.fEditor || JSMultiPageEditorPart.this.fEditor.getEditorInput() == JSMultiPageEditorPart.this.getEditorInput()) break;
                    JSMultiPageEditorPart.this.setInput(JSMultiPageEditorPart.this.fEditor.getEditorInput());
                    JSMultiPageEditorPart.this.setPartName(JSMultiPageEditorPart.this.fEditor.getEditorInput().getName());
                    break;
                }
                case 1: {
                    if (source != JSMultiPageEditorPart.this.fEditor || JSMultiPageEditorPart.this.fEditor.getEditorInput() == JSMultiPageEditorPart.this.getEditorInput()) break;
                    JSMultiPageEditorPart.this.setInput(JSMultiPageEditorPart.this.fEditor.getEditorInput());
                    break;
                }
                default: {
                    if (source != JSMultiPageEditorPart.this.fEditor) break;
                    JSMultiPageEditorPart.this.firePropertyChange(propId);
                }
            }
        }
    }
}

