/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

class RussianStemmer {
    private char[] charset;
    private int RV;
    private int R1;
    private int R2;
    private static final char A = '\u0000';
    private static final char V = '\u0002';
    private static final char G = '\u0003';
    private static final char E = '\u0005';
    private static final char I = '\b';
    private static final char I_ = '\t';
    private static final char L = '\u000b';
    private static final char M = '\f';
    private static final char N = '\r';
    private static final char O = '\u000e';
    private static final char S = '\u0011';
    private static final char T = '\u0012';
    private static final char U = '\u0013';
    private static final char X = '\u0015';
    private static final char SH = '\u0018';
    private static final char SHCH = '\u0019';
    private static final char Y = '\u001b';
    private static final char SOFT = '\u001c';
    private static final char AE = '\u001d';
    private static final char IU = '\u001e';
    private static final char IA = '\u001f';
    private static char[] vowels = new char[]{'\u0000', '\u0005', '\b', '\u000e', '\u0013', '\u001b', '\u001d', '\u001e', '\u001f'};
    private static char[][] perfectiveGerundEndings1 = new char[][]{{'\u0002'}, {'\u0002', '\u0018', '\b'}, {'\u0002', '\u0018', '\b', '\u0011', '\u001c'}};
    private static char[][] perfectiveGerund1Predessors = new char[][]{{'\u0000'}, {'\u001f'}};
    private static char[][] perfectiveGerundEndings2 = new char[][]{{'\b', '\u0002'}, {'\u001b', '\u0002'}, {'\b', '\u0002', '\u0018', '\b'}, {'\u001b', '\u0002', '\u0018', '\b'}, {'\b', '\u0002', '\u0018', '\b', '\u0011', '\u001c'}, {'\u001b', '\u0002', '\u0018', '\b', '\u0011', '\u001c'}};
    private static char[][] adjectiveEndings = new char[][]{{'\u0005', '\u0005'}, {'\b', '\u0005'}, {'\u001b', '\u0005'}, {'\u000e', '\u0005'}, {'\u0005', '\t'}, {'\b', '\t'}, {'\u001b', '\t'}, {'\u000e', '\t'}, {'\u0005', '\f'}, {'\b', '\f'}, {'\u001b', '\f'}, {'\u000e', '\f'}, {'\b', '\u0015'}, {'\u001b', '\u0015'}, {'\u0013', '\u001e'}, {'\u001e', '\u001e'}, {'\u0000', '\u001f'}, {'\u001f', '\u001f'}, {'\u000e', '\u001e'}, {'\u0005', '\u001e'}, {'\b', '\f', '\b'}, {'\u001b', '\f', '\b'}, {'\u0005', '\u0003', '\u000e'}, {'\u000e', '\u0003', '\u000e'}, {'\u0005', '\f', '\u0013'}, {'\u000e', '\f', '\u0013'}};
    private static char[][] participleEndings1 = new char[][]{{'\u0019'}, {'\u0005', '\f'}, {'\r', '\r'}, {'\u0002', '\u0018'}, {'\u001e', '\u0019'}};
    private static char[][] participleEndings2 = new char[][]{{'\b', '\u0002', '\u0018'}, {'\u001b', '\u0002', '\u0018'}, {'\u0013', '\u001e', '\u0019'}};
    private static char[][] participle1Predessors = new char[][]{{'\u0000'}, {'\u001f'}};
    private static char[][] reflexiveEndings = new char[][]{{'\u0011', '\u001f'}, {'\u0011', '\u001c'}};
    private static char[][] verbEndings1 = new char[][]{{'\t'}, {'\u000b'}, {'\r'}, {'\u000b', '\u000e'}, {'\r', '\u000e'}, {'\u0005', '\u0012'}, {'\u001e', '\u0012'}, {'\u000b', '\u0000'}, {'\r', '\u0000'}, {'\u000b', '\b'}, {'\u0005', '\f'}, {'\r', '\u001b'}, {'\u0005', '\u0012', '\u0005'}, {'\t', '\u0012', '\u0005'}, {'\u0012', '\u001c'}, {'\u0005', '\u0018', '\u001c'}, {'\r', '\r', '\u000e'}};
    private static char[][] verbEndings2 = new char[][]{{'\u001e'}, {'\u0013', '\u001e'}, {'\u0005', '\r'}, {'\u0005', '\t'}, {'\u001f', '\u0012'}, {'\u0013', '\t'}, {'\b', '\u000b'}, {'\u001b', '\u000b'}, {'\b', '\f'}, {'\u001b', '\f'}, {'\b', '\u0012'}, {'\u001b', '\u0012'}, {'\b', '\u000b', '\u0000'}, {'\u001b', '\u000b', '\u0000'}, {'\u0005', '\r', '\u0000'}, {'\b', '\u0012', '\u0005'}, {'\b', '\u000b', '\b'}, {'\u001b', '\u000b', '\b'}, {'\b', '\u000b', '\u000e'}, {'\u001b', '\u000b', '\u000e'}, {'\u0005', '\r', '\u000e'}, {'\u0013', '\u0005', '\u0012'}, {'\u0013', '\u001e', '\u0012'}, {'\u0005', '\r', '\u001b'}, {'\b', '\u0012', '\u001c'}, {'\u001b', '\u0012', '\u001c'}, {'\b', '\u0018', '\u001c'}, {'\u0005', '\t', '\u0012', '\u0005'}, {'\u0013', '\t', '\u0012', '\u0005'}};
    private static char[][] verb1Predessors = new char[][]{{'\u0000'}, {'\u001f'}};
    private static char[][] nounEndings = new char[][]{{'\u0000'}, {'\u0013'}, {'\t'}, {'\u000e'}, {'\u0013'}, {'\u0005'}, {'\u001b'}, {'\b'}, {'\u001c'}, {'\u001f'}, {'\u0005', '\u0002'}, {'\u000e', '\u0002'}, {'\b', '\u0005'}, {'\u001c', '\u0005'}, {'\u001f', '\u0015'}, {'\b', '\u001e'}, {'\u0005', '\b'}, {'\b', '\b'}, {'\u0005', '\t'}, {'\u000e', '\t'}, {'\u0005', '\f'}, {'\u0000', '\f'}, {'\u000e', '\f'}, {'\u0000', '\u0015'}, {'\u001c', '\u001e'}, {'\b', '\u001f'}, {'\u001c', '\u001f'}, {'\b', '\t'}, {'\u001f', '\f'}, {'\u001f', '\f', '\b'}, {'\u0000', '\f', '\b'}, {'\b', '\u0005', '\t'}, {'\b', '\u001f', '\f'}, {'\b', '\u0005', '\f'}, {'\b', '\u001f', '\u0015'}, {'\b', '\u001f', '\f', '\b'}};
    private static char[][] superlativeEndings = new char[][]{{'\u0005', '\t', '\u0018'}, {'\u0005', '\t', '\u0018', '\u0005'}};
    private static char[][] derivationalEndings = new char[][]{{'\u000e', '\u0011', '\u0012'}, {'\u000e', '\u0011', '\u0012', '\u001c'}};

    public RussianStemmer() {
    }

    public RussianStemmer(char[] charset) {
        this.charset = charset;
    }

    private boolean adjectival(StringBuffer stemmingZone) {
        if (!this.findAndRemoveEnding(stemmingZone, adjectiveEndings)) {
            return false;
        }
        boolean r = this.findAndRemoveEnding(stemmingZone, participleEndings1, participle1Predessors) || this.findAndRemoveEnding(stemmingZone, participleEndings2);
        return true;
    }

    private boolean derivational(StringBuffer stemmingZone) {
        int endingLength = this.findEnding(stemmingZone, derivationalEndings);
        if (endingLength == 0) {
            return false;
        }
        if (this.R2 - this.RV <= stemmingZone.length() - endingLength) {
            stemmingZone.setLength(stemmingZone.length() - endingLength);
            return true;
        }
        return false;
    }

    private int findEnding(StringBuffer stemmingZone, int startIndex, char[][] theEndingClass) {
        boolean match = false;
        for (int i = theEndingClass.length - 1; i >= 0; --i) {
            char[] theEnding = theEndingClass[i];
            if (startIndex < theEnding.length - 1) {
                match = false;
                continue;
            }
            match = true;
            int stemmingIndex = startIndex;
            for (int j = theEnding.length - 1; j >= 0; --j) {
                if (stemmingZone.charAt(stemmingIndex--) == this.charset[theEnding[j]]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return theEndingClass[i].length;
        }
        return 0;
    }

    private int findEnding(StringBuffer stemmingZone, char[][] theEndingClass) {
        return this.findEnding(stemmingZone, stemmingZone.length() - 1, theEndingClass);
    }

    private boolean findAndRemoveEnding(StringBuffer stemmingZone, char[][] theEndingClass) {
        int endingLength = this.findEnding(stemmingZone, theEndingClass);
        if (endingLength == 0) {
            return false;
        }
        stemmingZone.setLength(stemmingZone.length() - endingLength);
        return true;
    }

    private boolean findAndRemoveEnding(StringBuffer stemmingZone, char[][] theEndingClass, char[][] thePredessors) {
        int endingLength = this.findEnding(stemmingZone, theEndingClass);
        if (endingLength == 0) {
            return false;
        }
        int predessorLength = this.findEnding(stemmingZone, stemmingZone.length() - endingLength - 1, thePredessors);
        if (predessorLength == 0) {
            return false;
        }
        stemmingZone.setLength(stemmingZone.length() - endingLength);
        return true;
    }

    private void markPositions(String word) {
        int i;
        this.RV = 0;
        this.R1 = 0;
        this.R2 = 0;
        for (i = 0; word.length() > i && !this.isVowel(word.charAt(i)); ++i) {
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        this.RV = i;
        while (word.length() > i && this.isVowel(word.charAt(i))) {
            ++i;
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        this.R1 = i;
        while (word.length() > i && !this.isVowel(word.charAt(i))) {
            ++i;
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        while (word.length() > i && this.isVowel(word.charAt(i))) {
            ++i;
        }
        if (word.length() - 1 < ++i) {
            return;
        }
        this.R2 = i;
    }

    private boolean isVowel(char letter) {
        for (int i = 0; i < vowels.length; ++i) {
            if (letter != this.charset[vowels[i]]) continue;
            return true;
        }
        return false;
    }

    private boolean noun(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, nounEndings);
    }

    private boolean perfectiveGerund(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, perfectiveGerundEndings1, perfectiveGerund1Predessors) || this.findAndRemoveEnding(stemmingZone, perfectiveGerundEndings2);
    }

    private boolean reflexive(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, reflexiveEndings);
    }

    private boolean removeI(StringBuffer stemmingZone) {
        if (stemmingZone.length() > 0 && stemmingZone.charAt(stemmingZone.length() - 1) == this.charset[8]) {
            stemmingZone.setLength(stemmingZone.length() - 1);
            return true;
        }
        return false;
    }

    private boolean removeSoft(StringBuffer stemmingZone) {
        if (stemmingZone.length() > 0 && stemmingZone.charAt(stemmingZone.length() - 1) == this.charset[28]) {
            stemmingZone.setLength(stemmingZone.length() - 1);
            return true;
        }
        return false;
    }

    public void setCharset(char[] newCharset) {
        this.charset = newCharset;
    }

    public String stem(String input) {
        this.markPositions(input);
        if (this.RV == 0) {
            return input;
        }
        StringBuffer stemmingZone = new StringBuffer(input.substring(this.RV));
        if (!this.perfectiveGerund(stemmingZone)) {
            this.reflexive(stemmingZone);
            boolean bl = this.adjectival(stemmingZone) || this.verb(stemmingZone) || this.noun(stemmingZone);
        }
        this.removeI(stemmingZone);
        this.derivational(stemmingZone);
        this.superlative(stemmingZone);
        this.undoubleN(stemmingZone);
        this.removeSoft(stemmingZone);
        return input.substring(0, this.RV) + stemmingZone.toString();
    }

    private boolean superlative(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, superlativeEndings);
    }

    private boolean undoubleN(StringBuffer stemmingZone) {
        char[][] doubleN = new char[][]{{'\r', '\r'}};
        if (this.findEnding(stemmingZone, doubleN) != 0) {
            stemmingZone.setLength(stemmingZone.length() - 1);
            return true;
        }
        return false;
    }

    private boolean verb(StringBuffer stemmingZone) {
        return this.findAndRemoveEnding(stemmingZone, verbEndings1, verb1Predessors) || this.findAndRemoveEnding(stemmingZone, verbEndings2);
    }

    public static String stem(String theWord, char[] charset) {
        RussianStemmer stemmer = new RussianStemmer();
        stemmer.setCharset(charset);
        return stemmer.stem(theWord);
    }
}

