/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.preview.adapter.internal.IMemento;
import org.eclipse.jst.server.preview.adapter.internal.Messages;
import org.eclipse.jst.server.preview.adapter.internal.ProgressUtil;
import org.eclipse.jst.server.preview.adapter.internal.Trace;
import org.eclipse.jst.server.preview.adapter.internal.XMLMemento;
import org.eclipse.jst.server.preview.adapter.internal.core.PingThread;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.IStaticWeb;
import org.eclipse.wst.server.core.util.PublishUtil;
import org.eclipse.wst.server.core.util.SocketUtil;

public class PreviewServerBehaviour
extends ServerBehaviourDelegate {
    protected transient PingThread ping = null;
    protected transient IProcess process;
    protected transient IDebugEventSetListener processListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void initialize(IProgressMonitor monitor) {
    }

    public PreviewRuntime getPreviewRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.preview.adapter.internal.core.PreviewRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PreviewRuntime)((Object)iRuntime.loadAdapter((Class)clazz, null));
    }

    public PreviewServer getPreviewServer() {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.preview.adapter.internal.core.PreviewServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PreviewServer)((Object)iServer.getAdapter((Class)clazz));
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getServer().getRuntime().getLocation();
    }

    protected void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        ServerPort[] ports = this.getPreviewServer().getServerPorts();
        int port = ports[0].getPort();
        if (SocketUtil.isPortInUse((int)port, (int)5)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.preview.adapter", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port), this.getServer().getName()}), null));
        }
        XMLMemento memento = XMLMemento.createWriteRoot("server");
        memento.putInteger("port", port);
        IModule[] modules = this.getServer().getModules();
        int size = modules.length;
        int i = 0;
        while (i < size) {
            IMemento mod = memento.createChild("module");
            mod.putString("name", modules[i].getName());
            String type = modules[i].getModuleType().getId();
            if ("wst.web".equals(type)) {
                IModule iModule = modules[i];
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.server.core.util.IStaticWeb");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IStaticWeb staticWeb = (IStaticWeb)iModule.loadAdapter((Class)clazz, null);
                mod.putString("context", staticWeb.getContextRoot());
                mod.putString("type", "static");
            } else if ("jst.web".equals(type)) {
                IModule iModule = modules[i];
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jst.server.core.IWebModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IWebModule webModule = (IWebModule)iModule.loadAdapter((Class)clazz, null);
                mod.putString("context", webModule.getContextRoot());
                mod.putString("type", "j2ee");
            }
            mod.putString("path", this.getModulePublishDirectory(modules[i]).toPortableString());
            ++i;
        }
        try {
            memento.saveToFile(this.getTempDirectory().append("preview.xml").toOSString());
        }
        catch (IOException e) {
            Trace.trace((byte)2, "Could not write preview config", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.preview.adapter", 0, "Could not write preview configuration", null));
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://localhost";
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, this);
        }
        catch (Exception exception) {
            Trace.trace((byte)2, "Can't ping for Tomcat startup.");
        }
    }

    protected void setProcess(IProcess newProcess) {
        if (this.process != null) {
            return;
        }
        this.process = newProcess;
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
        }
        if (newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        Object obj = events[i].getSource();
                        if (obj instanceof IDebugTarget) {
                            IDebugTarget target = (IDebugTarget)obj;
                            IProcess targetProcess = target.getProcess();
                            if (PreviewServerBehaviour.this.process != null && PreviewServerBehaviour.this.process.equals(targetProcess) && events[i].getKind() == 8) {
                                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                PreviewServerBehaviour.this.stopImpl();
                            }
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void stopImpl() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.process != null) {
            this.process = null;
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        IModule module = moduleTree[moduleTree.length - 1];
        IPath to = this.getModulePublishDirectory(module);
        if (kind == 4 || deltaKind == 3) {
            IStatus[] status = PublishUtil.deleteDirectory((File)to.toFile(), (IProgressMonitor)monitor);
            PreviewServerBehaviour.throwException(status);
        }
        IModuleResource[] res = this.getResources(moduleTree);
        IStatus[] status = PublishUtil.publishSmart((IModuleResource[])res, (IPath)to, (IProgressMonitor)monitor);
        PreviewServerBehaviour.throwException(status);
        this.setModulePublishState(moduleTree, 1);
    }

    private static void throwException(IStatus[] status) throws CoreException {
        if (status == null || status.length == 0) {
            return;
        }
        if (status.length == 1) {
            throw new CoreException(status[0]);
        }
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.jst.server.preview.adapter", 0, status, message, null);
        throw new CoreException((IStatus)status2);
    }

    public void restart(String launchMode) throws CoreException {
        this.setServerState(4);
        this.setServerState(2);
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4) {
            return;
        }
        if (state == 1 || state == 3) {
            this.terminate();
            return;
        }
        this.terminate();
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            Trace.trace((byte)3, "Killing the HTTP process");
            if (this.process != null && !this.process.isTerminated()) {
                this.process.terminate();
            }
            this.stopImpl();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error killing the process", e);
        }
    }

    protected IPath getTempDirectory() {
        return super.getTempDirectory();
    }

    protected IPath getModulePublishDirectory(IModule module) {
        return this.getTempDirectory().append(module.getName());
    }

    public String toString() {
        return "PreviewServer";
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }
}

