/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedLimitedStream
extends BufferedInputStream {
    private int limitedCount;

    public BufferedLimitedStream(InputStream inStream, int size) {
        super(inStream, size);
        this.mark(size);
        try {
            this.limitedCount = Math.min(size, inStream.available());
        }
        catch (IOException iOException) {
            this.limitedCount = 0;
        }
    }

    public synchronized int available() throws IOException {
        return this.limitedCount - this.pos;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.limitedCount) {
            return -1;
        }
        return super.read();
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.limitedCount) {
            return -1;
        }
        return super.read(b, off, len);
    }
}

