/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.internal.Logger;

public class JarUtilities {
    public static final String JSP11_TAGLIB = "META-INF/taglib.tld";

    public static void closeJarFile(ZipFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException ioe) {
            Logger.logException("JarUtilities: Could not close file " + file.getName(), ioe);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static InputStream getCachedInputStream(String jarFilename, String entryName) {
        File testFile = new File(jarFilename);
        if (!testFile.exists()) {
            return null;
        }
        ByteArrayInputStream cache = null;
        ZipFile jarfile = null;
        try {
            jarfile = new ZipFile(jarFilename);
        }
        catch (IOException ioExc) {
            Logger.logException("JarUtilities: " + jarFilename, ioExc);
            JarUtilities.closeJarFile(jarfile);
        }
        if (jarfile == null) return cache;
        try {
            ZipEntry zentry = jarfile.getEntry(entryName);
            if (zentry != null) {
                InputStream entryInputStream = null;
                try {
                    entryInputStream = jarfile.getInputStream(zentry);
                }
                catch (IOException ioExc) {
                    Logger.logException("JarUtilities: " + jarFilename, ioExc);
                }
                if (entryInputStream != null) {
                    ByteArrayOutputStream buffer = null;
                    buffer = zentry.getSize() > 0L ? new ByteArrayOutputStream((int)zentry.getSize()) : new ByteArrayOutputStream();
                    byte[] bytes = new byte[2048];
                    try {
                        try {
                            while (true) {
                                int c;
                                if ((c = entryInputStream.read(bytes)) < 0) {
                                    cache = new ByteArrayInputStream(buffer.toByteArray());
                                    JarUtilities.closeJarFile(jarfile);
                                }
                                buffer.write(bytes, 0, c);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        try {
                            entryInputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        Object var10_14 = null;
                        try {}
                        catch (IOException iOException) {}
                        entryInputStream.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            JarUtilities.closeJarFile(jarfile);
            throw throwable;
        }
        {
            Object var12_17 = null;
        }
        JarUtilities.closeJarFile(jarfile);
        return cache;
    }

    private static InputStream copyAndCloseStream(InputStream original) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteArrayInputStream cachedCopy = null;
        if (original != null) {
            byte[] bytes = new byte[2048];
            try {
                int c;
                while ((c = original.read(bytes)) >= 0) {
                    buffer.write(bytes, 0, c);
                }
                cachedCopy = new ByteArrayInputStream(buffer.toByteArray());
                JarUtilities.closeStream(original);
            }
            catch (IOException iOException) {}
        }
        return cachedCopy;
    }

    public static String[] getEntryNames(IResource jarResource) {
        if (jarResource == null || jarResource.getType() != 1) {
            return new String[0];
        }
        if (jarResource.getLocation() == null) {
            try {
                return JarUtilities.getEntryNames(new ZipInputStream(((IFile)jarResource).getContents()), true);
            }
            catch (CoreException e) {
                Logger.logException("Problem reading contents of " + jarResource.getFullPath(), e);
            }
        }
        return JarUtilities.getEntryNames(jarResource.getLocation().toString());
    }

    public static String[] getEntryNames(String jarFilename) {
        return JarUtilities.getEntryNames(jarFilename, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getEntryNames(ZipInputStream jarInputStream, boolean excludeDirectories) {
        ArrayList<String> entryNames = new ArrayList<String>();
        try {
            try {
                ZipEntry z = jarInputStream.getNextEntry();
                while (z != null) {
                    if (!z.isDirectory() || !excludeDirectories) {
                        entryNames.add(z.getName());
                    }
                    z = jarInputStream.getNextEntry();
                }
            }
            catch (ZipException zExc) {
                Logger.log(2, "JarUtilities ZipException: (stream) " + zExc.getMessage());
            }
            catch (IOException ioExc) {
                Logger.log(2, "JarUtilities IOException: (stream) " + ioExc.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            JarUtilities.closeStream(jarInputStream);
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        JarUtilities.closeStream(jarInputStream);
        return entryNames.toArray(new String[0]);
    }

    private static void closeStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getEntryNames(String jarFilename, boolean excludeDirectories) {
        ZipFile jarfile = null;
        ArrayList<String> entryNames = new ArrayList<String>();
        try {
            try {
                jarfile = new ZipFile(jarFilename);
                Enumeration<? extends ZipEntry> entries = jarfile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry z = entries.nextElement();
                    if (z.isDirectory() && excludeDirectories) continue;
                    entryNames.add(z.getName());
                }
            }
            catch (ZipException zExc) {
                Logger.log(2, "JarUtilities ZipException: " + jarFilename + " " + zExc.getMessage());
            }
            catch (IOException ioExc) {
                Logger.log(2, "JarUtilities IOException: " + jarFilename + " " + ioExc.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            JarUtilities.closeJarFile(jarfile);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        JarUtilities.closeJarFile(jarfile);
        return entryNames.toArray(new String[0]);
    }

    public static InputStream getInputStream(IResource jarResource, String entryName) {
        if (jarResource == null || jarResource.getType() != 1) {
            return null;
        }
        IPath location = jarResource.getLocation();
        if (location == null) {
            try {
                InputStream zipStream = ((IFile)jarResource).getContents();
                return JarUtilities.getInputStream(new ZipInputStream(zipStream), entryName);
            }
            catch (CoreException e) {
                Logger.logException("Problem reading contents of " + jarResource.getFullPath(), e);
                return null;
            }
        }
        return JarUtilities.getInputStream(location.toString(), entryName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream getInputStream(ZipInputStream zip, String entryName) {
        InputStream result = null;
        try {
            try {
                ZipEntry z = zip.getNextEntry();
                while (true) {
                    block8: {
                        if (z != null && !z.getName().equals(entryName)) break block8;
                        if (z != null) {
                            result = JarUtilities.copyAndCloseStream(zip);
                        }
                        break;
                    }
                    z = zip.getNextEntry();
                }
            }
            catch (ZipException zExc) {
                Logger.log(2, "JarUtilities ZipException: (stream) " + zExc.getMessage());
            }
            catch (IOException ioExc) {
                Logger.log(2, "JarUtilities IOException: (stream) " + ioExc.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            JarUtilities.closeStream(zip);
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        JarUtilities.closeStream(zip);
        return result;
    }

    public static InputStream getInputStream(String jarFilename, String entryName) {
        if (jarFilename == null || jarFilename.length() < 1 || entryName == null || entryName.length() < 1) {
            return null;
        }
        String internalName = null;
        internalName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        return JarUtilities.getCachedInputStream(jarFilename, internalName);
    }
}

