/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.wizard.simplefe;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.CXFResources;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.cxf.natures.CxfSimpleFrontendNature;
import org.eclipse.stp.sc.cxf.wizard.CxfStartingPointPageContents;
import org.eclipse.stp.sc.cxf.wizard.simplefe.CxfJava2wsParameterPageContentsSimple;
import org.eclipse.stp.sc.cxf.wizard.simplefe.StartingPointWizardPageSimple;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPostProjectProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWizardPageContentsBase;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.AdditionalWizardPage;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.stp.sc.jaxws.workspace.ScNature;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class SimpleFrontendProjectWizard
extends Wizard
implements INewWizard {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(SimpleFrontendProjectWizard.class);
    private final String DEFAULT_RUNTIME_TYPE = "org.eclipse.stp.soas.deploy.runtime.cxf.20";
    public final String STARTING_POINT_PAGE_NAME = "startingPointPage";
    public final String PARAMETER_PAGE_NAME = "parameterPage";
    public final String PROJECT_PAGE_NAME = "genPage";
    StartingPointWizardPageSimple startingPointPage;
    AdditionalWizardPage parameterPage;
    WizardNewProjectCreationPage genPage;
    private String runtimeID;
    private String runtimeType = "org.eclipse.stp.soas.deploy.runtime.cxf.20";
    private String projectMode = "JavaFrist";
    private IProject project;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        RuntimeProviderManager mgr = RuntimeProviderManager.getInstance();
        String[] ids = mgr.getRuntimeIDs(this.runtimeType);
        if (ids == null || ids.length <= 0) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Missing Runtime", (String)"There is no corresponding CXF runtime installed. Please add this runtime first.");
            return;
        }
        this.runtimeID = ids[0];
        this.genPage = new WizardNewProjectCreationPage("genPage");
        this.genPage.setTitle(CXFResources.getString("Wizard.Simple.Frontend.Project.Page.Title"));
        this.genPage.setDescription(CXFResources.getString("Wizard.Simple.Frontend.Project.Page.Descritption"));
        this.addPage((IWizardPage)this.genPage);
        this.startingPointPage = new StartingPointWizardPageSimple("startingPointPage");
        CxfStartingPointPageContents pageContents = new CxfStartingPointPageContents();
        pageContents.setChangeListener((IPageContentsChangeListener)this.startingPointPage);
        this.startingPointPage.setPageContents((IWizardPageContentsBase)pageContents);
        this.addPage((IWizardPage)this.startingPointPage);
        this.parameterPage = new AdditionalWizardPage("parameterPage", (IAdditionalPageContents)new CxfJava2wsParameterPageContentsSimple());
        this.startingPointPage.setNextPage((IWizardPage)this.parameterPage);
        this.addPage((IWizardPage)this.parameterPage);
    }

    public boolean performFinish() {
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SimpleFrontendProjectWizard.this.createProject(monitor);
                }
            };
            pmd.run(false, false, rwp);
            this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_FRONT_END, "simple");
            ScNature.removeFromProject((IProject)this.project);
            CxfSimpleFrontendNature.addToProject(this.project);
            this.startingPointPage.performFinish(this.project);
            this.parameterPage.performFinish(this.project);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean createProject(IProgressMonitor newMonitor) throws InvocationTargetException {
        IProgressMonitor checkedMonitor = newMonitor != null ? newMonitor : new NullProgressMonitor();
        checkedMonitor.beginTask("", 100);
        SubProgressMonitor createProjectMonitor = new SubProgressMonitor(checkedMonitor, 20);
        this.project = JaxWsWorkspaceManager.createProject((IProgressMonitor)createProjectMonitor, (String)this.genPage.getProjectName(), (IPath)this.genPage.getLocationPath(), (String)this.projectMode, (String)this.runtimeType, (String)this.runtimeID);
        IPostProjectProcessor processor = RuntimeProviderManager.getInstance().getPostProjectProcessor(this.runtimeType);
        if (processor != null) {
            processor.postProcess(this.project);
        }
        try {
            try {
                this.project.refreshLocal(2, checkedMonitor);
            }
            catch (Exception ce) {
                LOG.error((Object)ce.getMessage(), (Throwable)ce);
                ce.printStackTrace();
                checkedMonitor.done();
            }
        }
        finally {
            checkedMonitor.done();
        }
        return true;
    }
}

