/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.actions.XSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDModelGroupCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;

public class AddXSDModelGroupAction
extends XSDBaseAction {
    public static String SEQUENCE_ID = "AddXSDSequenceModelGroupAction";
    public static String CHOICE_ID = "AddXSDChoiceModelGroupAction";
    public static String ALL_ID = "AddXSDAllModelGroupAction";
    XSDCompositor xsdCompositor;

    public AddXSDModelGroupAction(IWorkbenchPart part, XSDCompositor compositor, String ID) {
        super(part);
        this.setText(this.getLabel(compositor));
        this.setId(ID);
        this.xsdCompositor = compositor;
    }

    public void run() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDBaseAdapter) {
            Adapter adapter;
            XSDConcreteComponent xsdComponent = (XSDConcreteComponent)((XSDBaseAdapter)selection).getTarget();
            BaseCommand command = null;
            if (xsdComponent instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
                command = new AddXSDModelGroupCommand(this.getLabel(this.xsdCompositor), (XSDConcreteComponent)xsdElementDeclaration, this.xsdCompositor);
                this.getCommandStack().execute((Command)command);
            } else if (xsdComponent instanceof XSDModelGroup) {
                XSDModelGroup xsdModelGroup = (XSDModelGroup)xsdComponent;
                command = new AddXSDModelGroupCommand(this.getLabel(this.xsdCompositor), (XSDConcreteComponent)xsdModelGroup, this.xsdCompositor);
                this.getCommandStack().execute((Command)command);
            } else if (xsdComponent instanceof XSDComplexTypeDefinition) {
                command = new AddXSDModelGroupCommand(this.getLabel(this.xsdCompositor), xsdComponent, this.xsdCompositor);
                this.getCommandStack().execute((Command)command);
            }
            if (command != null && (adapter = XSDAdapterFactory.getInstance().adapt((Notifier)command.getAddedComponent())) != null) {
                this.provider.setSelection((ISelection)new StructuredSelection((Object)adapter));
            }
        }
    }

    private String getLabel(XSDCompositor compositor) {
        String result = XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_SEQUENCE");
        if (compositor != null) {
            if (compositor == XSDCompositor.CHOICE_LITERAL) {
                result = XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_CHOICE");
            } else if (compositor == XSDCompositor.ALL_LITERAL) {
                result = XSDEditorPlugin.getXSDString("_UI_ACTION_ADD_ALL");
            }
        }
        return result;
    }
}

