/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.java.JpaCompilationUnit;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public void sessionStarted() {
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return context instanceof JavaContentAssistInvocationContext ? this.computeCompletionProposals((JavaContentAssistInvocationContext)context) : Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            return this.computeCompletionProposals_(context);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<ICompletionProposal> computeCompletionProposals_(JavaContentAssistInvocationContext context) throws JavaModelException {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return Collections.emptyList();
        }
        IJpaFile jpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)cu.getCorrespondingResource()));
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        JpaCompilationUnit jpaCU = (JpaCompilationUnit)jpaFile.getContent();
        CompletionContext cc = context.getCoreContext();
        char[] prefix = cc.getToken();
        Filter filter = prefix == null ? Filter.Null.instance() : new IgnoreCasePrefixFilter(prefix);
        int tokenStart = cc.getTokenStart();
        int tokenEnd = cc.getTokenEnd();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Iterator stream = jpaCU.candidateValuesFor(context.getInvocationOffset(), filter);
        while (stream.hasNext()) {
            String s = (String)stream.next();
            proposals.add((ICompletionProposal)new CompletionProposal(s, tokenStart, tokenEnd - tokenStart + 1, s.length()));
        }
        return proposals;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreCasePrefixFilter
    implements Filter<String> {
        private final char[] prefix;

        IgnoreCasePrefixFilter(char[] prefix) {
            this.prefix = prefix;
        }

        public boolean accept(String s) {
            return StringTools.stringStartsWithIgnoreCase((char[])s.toCharArray(), (char[])this.prefix);
        }
    }
}

