/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class BaseJpaController {
    protected CommandStack commandStack;
    protected TabbedPropertySheetWidgetFactory widgetFactory;
    private boolean populating;

    public BaseJpaController(Composite parent, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.buildWidget(parent);
        this.commandStack = theCommandStack;
    }

    public BaseJpaController(Composite parent, int style, CommandStack theCommandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.buildWidget(parent, style);
        this.commandStack = theCommandStack;
    }

    protected void buildWidget(Composite parent) {
    }

    protected void buildWidget(Composite parent, int style) {
    }

    public final void populate(EObject obj) {
        if (this.getControl().isDisposed()) {
            return;
        }
        this.populating = true;
        this.disengageListeners();
        this.doPopulate(obj);
        this.engageListeners();
        this.populating = false;
    }

    public final void populate() {
        if (this.getControl().isDisposed()) {
            return;
        }
        this.populating = true;
        this.doPopulate();
        this.populating = false;
    }

    protected abstract void doPopulate(EObject var1);

    protected abstract void doPopulate();

    protected abstract void engageListeners();

    protected abstract void disengageListeners();

    protected boolean isPopulating() {
        return this.populating;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void dispose() {
        this.disengageListeners();
    }

    public abstract Control getControl();
}

