/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveWrapper {
    private Archive commonArchive = null;
    private IArchive archive = null;
    private JavaEEQuickPeek jqp = null;
    private ArchiveWrapper cachedParent = null;
    private List<ArchiveWrapper> cachedWebLibs;
    private List<ArchiveWrapper> cachedEARModules;
    private String[] cachedWebContextRoot = null;
    private ArchiveWrapper[] cachedEJBClientArchiveWrapper = null;
    private List<ArchiveWrapper> cachedEARUtilitiesAndWebLibs = null;

    public ArchiveWrapper(IArchive archive) {
        this.archive = archive;
        JavaEEArchiveUtilities jea = JavaEEArchiveUtilities.INSTANCE;
        this.jqp = jea.getJavaEEQuickPeek(archive);
    }

    public ArchiveWrapper(Archive mFile) {
        this.commonArchive = mFile;
        int type = -1;
        if (mFile.isApplicationClientFile()) {
            type = 3;
        } else if (mFile.isEARFile()) {
            type = 1;
        } else if (mFile.isEJBJarFile()) {
            type = 0;
        } else if (mFile.isWARFile()) {
            type = 4;
        } else if (mFile.isRARFile()) {
            type = 2;
        }
        if (type != -1) {
            int version = ArchiveUtil.getFastSpecVersion((ModuleFile)((ModuleFile)mFile));
            this.jqp = new JavaEEQuickPeek(type, version);
        } else {
            this.jqp = new JavaEEQuickPeek(null);
        }
    }

    public JavaEEQuickPeek getJavaEEQuickPeek() {
        return this.jqp;
    }

    public Archive getCommonArchive() {
        return this.commonArchive;
    }

    public Object getUnderLyingArchive() {
        if (this.archive != null) {
            return this.archive;
        }
        if (this.commonArchive != null) {
            return this.commonArchive;
        }
        this.fail();
        return null;
    }

    public ArchiveWrapper getParent() {
        if (this.cachedParent != null) {
            return this.cachedParent;
        }
        if (this.archive != null) {
            this.cachedParent = new ArchiveWrapper(this.archive.getArchive());
            return this.cachedParent;
        }
        if (this.commonArchive != null) {
            this.cachedParent = new ArchiveWrapper((Archive)this.commonArchive.eContainer());
            return this.cachedParent;
        }
        this.fail();
        return null;
    }

    public IArchive getIArchive() {
        return this.archive;
    }

    public void close() {
        try {
            if (this.commonArchive != null) {
                this.commonArchive.close();
            }
            if (this.archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
        catch (RuntimeException e) {
            Logger.getLogger().logError((Throwable)e);
            throw e;
        }
    }

    public IPath getPath() {
        if (this.commonArchive != null) {
            Path path = new Path(this.commonArchive.getURI());
            return path;
        }
        if (this.archive != null) {
            return this.archive.getPath();
        }
        this.fail();
        return null;
    }

    private void fail() {
        throw new RuntimeException("ArchiveWrapper is inconsistent.");
    }

    public int getSize() {
        if (this.commonArchive != null) {
            return this.commonArchive.getFiles().size();
        }
        return this.archive.getArchiveResources().size();
    }

    public List<ArchiveWrapper> getWebLibs() {
        if (this.cachedWebLibs != null) {
            return this.cachedWebLibs;
        }
        if (this.jqp.getType() != 4) {
            this.fail();
        }
        this.cachedWebLibs = new ArrayList<ArchiveWrapper>();
        if (this.commonArchive != null) {
            WARFile war = (WARFile)this.commonArchive;
            List libs = war.getLibArchives();
            int i = 0;
            while (i < libs.size()) {
                this.cachedWebLibs.add(new ArchiveWrapper((Archive)libs.get(i)));
                ++i;
            }
            return this.cachedWebLibs;
        }
        if (this.archive != null) {
            List resources = this.archive.getArchiveResources();
            for (IArchiveResource resource : resources) {
                String lastSegment;
                IPath path;
                if (resource.getType() == 1 || (path = resource.getPath()).segmentCount() <= 2 || !path.segment(0).equals("WEB-INF") || !path.segment(1).equals("lib") || !(lastSegment = path.lastSegment()).endsWith("jar") && !lastSegment.endsWith("zip")) continue;
                try {
                    IArchive webLib = this.archive.getNestedArchive(resource);
                    this.cachedWebLibs.add(new ArchiveWrapper(webLib));
                }
                catch (ArchiveOpenFailureException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            return this.cachedWebLibs;
        }
        this.fail();
        return null;
    }

    public List<ArchiveWrapper> getEarModules() {
        if (this.cachedEARModules != null) {
            return this.cachedEARModules;
        }
        if (this.jqp.getType() != 1) {
            this.fail();
        }
        this.cachedEARModules = new ArrayList<ArchiveWrapper>();
        if (this.commonArchive != null) {
            EARFile ear = (EARFile)this.commonArchive;
            List earMods = ear.getModuleFiles();
            int i = 0;
            while (i < earMods.size()) {
                this.cachedEARModules.add(new ArchiveWrapper((Archive)earMods.get(i)));
                ++i;
            }
            return this.cachedEARModules;
        }
        if (this.archive != null) {
            List resources = this.archive.getArchiveResources();
            for (IArchiveResource resource : resources) {
                String lastSegment;
                IPath path;
                if (resource.getType() == 1 || (path = resource.getPath()).segmentCount() <= 0 || !(lastSegment = path.lastSegment()).endsWith("jar") && !lastSegment.endsWith("zip") && !lastSegment.endsWith("rar") && !lastSegment.endsWith("war")) continue;
                try {
                    IArchive earmodule = this.archive.getNestedArchive(resource);
                    this.cachedEARModules.add(new ArchiveWrapper(earmodule));
                }
                catch (ArchiveOpenFailureException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            return this.cachedEARModules;
        }
        this.fail();
        return null;
    }

    public String getName() {
        if (this.commonArchive != null) {
            return this.commonArchive.getName();
        }
        if (this.archive != null) {
            return this.archive.getPath().lastSegment();
        }
        this.fail();
        return null;
    }

    public boolean isModule() {
        if (this.isApplicationClientFile()) {
            return true;
        }
        if (this.isWARFile()) {
            return true;
        }
        if (this.isEJBJarFile()) {
            return true;
        }
        return this.isRARFile();
    }

    public boolean isApplicationClientFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isApplicationClientFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 3;
        }
        this.fail();
        return false;
    }

    public boolean isWARFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isWARFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 4;
        }
        this.fail();
        return false;
    }

    public boolean isEJBJarFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isEJBJarFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 0;
        }
        this.fail();
        return false;
    }

    public boolean isEarFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isEARFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 1;
        }
        this.fail();
        return false;
    }

    public boolean isRARFile() {
        if (this.commonArchive != null) {
            return this.commonArchive.isRARFile();
        }
        if (this.archive != null) {
            return JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.archive).getType() == 2;
        }
        this.fail();
        return false;
    }

    public String getWebContextRoot() {
        if (this.cachedWebContextRoot != null) {
            return this.cachedWebContextRoot[0];
        }
        if (!this.isWARFile()) {
            this.fail();
            return null;
        }
        this.cachedWebContextRoot = new String[1];
        if (this.commonArchive != null) {
            this.cachedWebContextRoot[0] = ((WebModule)((EARFile)this.commonArchive.getContainer()).getModule(this.commonArchive.getURI(), null)).getContextRoot();
            return this.cachedWebContextRoot[0];
        }
        if (this.archive != null) {
            IArchive earArchive = this.archive.getArchive();
            if (earArchive.containsArchiveResource((IPath)new Path("META-INF/application.xml"))) {
                try {
                    Application application = (Application)earArchive.getModelObject();
                    String moduleName = this.archive.getPath().toString();
                    Module module = application.getFirstModule(moduleName);
                    this.cachedWebContextRoot[0] = module.getWeb().getContextRoot();
                }
                catch (ArchiveModelLoadException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            } else {
                String contextRoot = this.archive.getPath().toString();
                this.cachedWebContextRoot[0] = contextRoot = contextRoot.substring(0, contextRoot.lastIndexOf(46));
            }
            return this.cachedWebContextRoot[0];
        }
        this.fail();
        return null;
    }

    public ArchiveWrapper getEJBClientArchiveWrapper(ArchiveWrapper ejbWrapper) {
        if (this.cachedEJBClientArchiveWrapper != null) {
            return this.cachedEJBClientArchiveWrapper[0];
        }
        if (!ejbWrapper.isEJBJarFile() || !this.isEarFile()) {
            this.fail();
            return null;
        }
        this.cachedEJBClientArchiveWrapper = new ArchiveWrapper[1];
        if (this.commonArchive != null) {
            try {
                org.eclipse.jst.j2ee.ejb.EJBJar jar = ((EJBJarFile)ejbWrapper.getUnderLyingArchive()).getDeploymentDescriptor();
                if (jar != null && jar.getEjbClientJar() != null) {
                    String clientName = jar.getEjbClientJar();
                    this.cachedEJBClientArchiveWrapper[0] = new ArchiveWrapper((Archive)((EARFile)this.commonArchive).getFile(clientName));
                }
                return this.cachedEJBClientArchiveWrapper[0];
            }
            catch (FileNotFoundException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        if (this.archive != null) {
            try {
                JavaEEQuickPeek jqp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(ejbWrapper.archive);
                String clientJar = null;
                if (jqp.getVersion() == 30) {
                    if (ejbWrapper.archive.containsArchiveResource((IPath)new Path("META-INF/ejb-jar.xml"))) {
                        EJBJar edd = (EJBJar)ejbWrapper.archive.getModelObject();
                        clientJar = edd.getEjbClientJar();
                    }
                } else {
                    org.eclipse.jst.j2ee.ejb.EJBJar jar = (org.eclipse.jst.j2ee.ejb.EJBJar)ejbWrapper.archive.getModelObject();
                    if (jar != null) {
                        clientJar = jar.getEjbClientJar();
                    }
                }
                if (clientJar != null) {
                    IArchiveResource ar = this.archive.getArchiveResource((IPath)new Path(clientJar));
                    if (ar.getType() == 2) {
                        this.cachedEJBClientArchiveWrapper[0] = new ArchiveWrapper((IArchive)ar);
                    } else {
                        try {
                            this.cachedEJBClientArchiveWrapper[0] = new ArchiveWrapper(this.archive.getNestedArchive(ar));
                        }
                        catch (ArchiveOpenFailureException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    }
                }
                return this.cachedEJBClientArchiveWrapper[0];
            }
            catch (FileNotFoundException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (ArchiveModelLoadException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        this.fail();
        return null;
    }

    public List<ArchiveWrapper> getEARUtilitiesAndWebLibs() {
        if (this.cachedEARUtilitiesAndWebLibs != null) {
            return this.cachedEARUtilitiesAndWebLibs;
        }
        if (!this.isEarFile()) {
            this.fail();
            return null;
        }
        this.cachedEARUtilitiesAndWebLibs = new ArrayList<ArchiveWrapper>();
        if (this.commonArchive != null) {
            EList files = this.commonArchive.getFiles();
            int i = 0;
            while (i < files.size()) {
                FileImpl file = (FileImpl)files.get(i);
                if (file.isArchive() && !file.isModuleFile() && file.getURI().endsWith(".jar")) {
                    this.cachedEARUtilitiesAndWebLibs.add(new ArchiveWrapper((Archive)file));
                }
                if (file.isWARFile()) {
                    ArchiveWrapper wrapper = new ArchiveWrapper((Archive)file);
                    this.cachedEARUtilitiesAndWebLibs.addAll(wrapper.getWebLibs());
                }
                ++i;
            }
            return this.cachedEARUtilitiesAndWebLibs;
        }
        if (this.archive != null) {
            List files = this.archive.getArchiveResources();
            int i = 0;
            while (i < files.size()) {
                IArchiveResource file = (IArchiveResource)files.get(i);
                String lastSegment = file.getPath().lastSegment();
                if (lastSegment.endsWith(".jar") || lastSegment.endsWith(".rar") || lastSegment.endsWith(".war") || lastSegment.endsWith("zip")) {
                    try {
                        IArchive nestedArchive = this.archive.getNestedArchive(file);
                        ArchiveWrapper nestedWrapper = new ArchiveWrapper(nestedArchive);
                        if (nestedWrapper.isWARFile()) {
                            this.cachedEARUtilitiesAndWebLibs.addAll(nestedWrapper.getWebLibs());
                        } else if (!nestedWrapper.isModule()) {
                            this.cachedEARUtilitiesAndWebLibs.add(nestedWrapper);
                        }
                    }
                    catch (ArchiveOpenFailureException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                ++i;
            }
            return this.cachedEARUtilitiesAndWebLibs;
        }
        this.fail();
        return null;
    }
}

